/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.debug.DebugableDrawer;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DebugContainerRenderer
implements Renderer {
    private final DrawableNodeContainer<?> container;

    private DebugContainerRenderer(@NotNull DrawableNodeContainer<?> container) {
        this.container = container;
    }

    public static DebugContainerRenderer create(DrawableNodeContainer<?> container) {
        return new DebugContainerRenderer(container);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        Rectangle rectangle = context.getRectangle();
        Graphics graphics = context.getGraphics();
        if (context.isDrawableBounds()) {
            for (Drawable drawable : this.container.getDrawables()) {
                graphics.setForeground(Color.GREEN);
                graphics.setStroke(Stroke.TWO_SOLID);
                Rectangle bounds = context.scaleRectangle(drawable.getBounds(context));
                graphics.draw(bounds.shrink(1));
            }
        }
        if (context.isDrawableDebug()) {
            DebugableDrawer.drawDebugInfo(context, this.container);
        }
        if (context.isDrawableRedrawRegions()) {
            System.out.println("DebugContainerRenderer.render :: Showing re-draw regions when scaled > " + rectangle);
            graphics.setForeground(Color.YELLOW);
            graphics.setStroke(Stroke.TWO_SOLID);
            graphics.draw(rectangle.shrink(1));
        }
    }
}

