/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.diagram;

import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class DiagramEvent {
    private final Date activation;
    private final String flowElementId;
    private final DiagramEventType type;

    public DiagramEvent(@NotNull DiagramEventType type, @NotNull String flowElementId, @NotNull Date activation) {
        this.type = type;
        this.flowElementId = flowElementId;
        this.activation = activation;
    }

    public static DiagramEvent create(@NotNull DiagramEventType type, @NotNull String flowElementId, @NotNull Date activation) {
        return new DiagramEvent(type, flowElementId, activation);
    }

    @NotNull
    public DiagramEventType getType() {
        return this.type;
    }

    @NotNull
    public String getFlowElementId() {
        return this.flowElementId;
    }

    @NotNull
    public Date getActivation() {
        return this.activation;
    }

    public static enum DiagramEventType {
        FLOW_NODE_IN,
        SEQUENCE_FLOW;

    }
}

