/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import oracle.bpm.collections.lists.StringList;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.debug.Debugable;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

class TransitionDebugable
extends Debugable.Default
implements Debugable.LocatedDebugable,
Debugable.ColoredDebugable {
    private final DrawContext context;

    public TransitionDebugable(@NotNull DrawContext context) {
        this.context = context;
    }

    @Override
    public void attachDebugInfo(@NotNull Drawable original, @NotNull StringList info) {
        DrawableSequenceFlow drawable = (DrawableSequenceFlow)original;
        this.attachKeyValue(info, "from", drawable.getFromLocation().toString());
        this.attachKeyValue(info, "to", drawable.getToLocation().toString());
        this.attachKeyValue(info, "control", !this.hasControlPoint(drawable) ? "??" : drawable.getControlPoint(this.context).toString());
    }

    @Override
    public boolean accepts(@NotNull Drawable drawable) {
        return drawable instanceof DrawableSequenceFlow;
    }

    @Override
    @NotNull
    public Point getSpecificLocation(@NotNull DrawContext context, @NotNull Drawable drawable) {
        DrawableSequenceFlow sequenceFlow = (DrawableSequenceFlow)drawable;
        Point result = sequenceFlow.getControlPoint(context);
        if (!this.hasControlPoint(sequenceFlow)) {
            result = Point.avg((Point[])new Point[]{sequenceFlow.getFromLocation(), sequenceFlow.getToLocation()});
        }
        return result;
    }

    @Override
    @NotNull
    public Color getSpecificColor(@NotNull DrawContext context, @NotNull Drawable drawable) {
        return Color.valueOf((int)230, (int)170, (int)0, (int)200);
    }

    private boolean hasControlPoint(@NotNull DrawableSequenceFlow drawable) {
        return !drawable.getControlPoint(this.context).equals((Object)SequenceFlow.NULL_CONTROL_POINT);
    }
}

