/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import java.util.Arrays;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.debug.BaseDebugable;
import oracle.bpm.draw.debug.Debugable;
import oracle.bpm.draw.debug.DebugableAppender;
import oracle.bpm.draw.debug.LaneColumnDebugable;
import oracle.bpm.draw.debug.LaneDebugable;
import oracle.bpm.draw.debug.PositionalDebugable;
import oracle.bpm.draw.debug.TransitionDebugable;
import org.jetbrains.annotations.NotNull;

class DebugableFactory {
    private static Sequence<Debugable> debugables;

    DebugableFactory() {
    }

    @NotNull
    static DebugableAppender create(@NotNull DrawContext context, @NotNull Drawable drawable) {
        DebugableAppender result = new DebugableAppender();
        for (Debugable debugable : DebugableFactory.getDebugables(context)) {
            if (!debugable.accepts(drawable)) continue;
            result.add(debugable);
        }
        return result;
    }

    private static Sequence<Debugable> getDebugables(@NotNull DrawContext context) {
        if (debugables == null) {
            Debugable[] array = new Debugable[]{new BaseDebugable(context), new PositionalDebugable(), new LaneDebugable(), new LaneColumnDebugable(context), new TransitionDebugable(context)};
            debugables = CollectionUtils.asSequence(Arrays.asList(array));
        }
        return debugables;
    }
}

