/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import oracle.bpm.collections.lists.StringList;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.geom.Point;
import org.jetbrains.annotations.NotNull;

interface Debugable {
    public boolean accepts(@NotNull Drawable var1);

    public void attachDebugInfo(@NotNull Drawable var1, @NotNull StringList var2);

    public static abstract class Default
    implements Debugable {
        protected final void attachKeyValue(@NotNull StringList info, @NotNull String key, @NotNull Integer value) {
            this.attachKeyValue(info, key, String.valueOf(value));
        }

        protected final void attachKeyValue(@NotNull StringList info, @NotNull String key, @NotNull String value) {
            info.add((Object)key.concat(": ").concat(value));
        }
    }

    public static interface LocatedDebugable
    extends Debugable {
        @NotNull
        public Point getSpecificLocation(@NotNull DrawContext var1, @NotNull Drawable var2);
    }

    public static interface ColoredDebugable
    extends Debugable {
        @NotNull
        public Color getSpecificColor(@NotNull DrawContext var1, @NotNull Drawable var2);
    }
}

