/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.HashMap;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.log.Log;
import oracle.bpm.ui.Button;
import oracle.bpm.util.Base64;

public class Utilities {
    public static HashMap<Dimension, HashMap<Color, oracle.bpm.ui.Image>> imageMap = new HashMap();

    public static String getEncodedImage(String filename) {
        try {
            File file = new File(filename);
            byte[] byteImage = new byte[(int)file.length()];
            return Base64.encode((byte[])byteImage);
        }
        catch (SecurityException se) {
            Log.logWarning((Throwable)se);
        }
        catch (NullPointerException npe) {
            Log.logWarning((Throwable)npe);
        }
        return null;
    }

    public static void fitButtonToImage(Button button) {
        oracle.bpm.ui.Image i = button.getIcon();
        if (i != null) {
            button.setExactSize(Dimension.valueOf((int)i.getIconWidth(), (int)i.getIconHeight()));
        }
    }

    public static oracle.bpm.ui.Image invertImage(oracle.bpm.ui.Image image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage bisrc = new BufferedImage(width, height, 1);
        BufferedImage bidst = new BufferedImage(width, height, 1);
        java.awt.Graphics biContext = bisrc.getGraphics();
        biContext.drawImage(image.asAwtImage(), 0, 0, null);
        byte[] reverse = new byte[256];
        for (int j = 0; j < 256; ++j) {
            reverse[j] = j == 192 || j > 250 ? (byte)j : (byte)(256 - j);
        }
        ByteLookupTable blut = new ByteLookupTable(0, reverse);
        LookupOp lop = new LookupOp(blut, null);
        lop.filter(bisrc, bidst);
        WritableRaster raster = bidst.getRaster();
        int[] pixel = new int[4];
        for (int y = 0; y < bidst.getHeight(); ++y) {
            for (int x = 0; x < bidst.getWidth(); ++x) {
                if ((pixel = raster.getPixel(x, y, pixel))[0] != 192 && pixel[0] <= 250 || pixel[1] != 192 && pixel[1] <= 250 || pixel[2] != 192 && pixel[2] <= 250) continue;
                pixel[3] = 0;
                raster.setPixel(x, y, pixel);
            }
        }
        return oracle.bpm.ui.Image.create((Image)bidst);
    }

    public static oracle.bpm.ui.Image buildRectangleImage(int w, int h, Color fillColor) {
        return Utilities.buildRectangleImage(w, h, fillColor, true);
    }

    public static oracle.bpm.ui.Image buildRectangleImage(int w, int h, Color fillColor, boolean paintBorder) {
        oracle.bpm.ui.Image image;
        HashMap<Object, Object> colorMap = imageMap.get(Dimension.valueOf((int)w, (int)h));
        if (colorMap == null) {
            colorMap = new HashMap();
            imageMap.put(Dimension.valueOf((int)w, (int)h), colorMap);
        }
        if ((image = colorMap.get(fillColor)) == null) {
            image = oracle.bpm.ui.Image.create((int)w, (int)h);
            colorMap.put(fillColor, image);
            Utilities.paintImage(image, fillColor, paintBorder);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintImage(oracle.bpm.ui.Image image, Color color, boolean paintBorder) {
        Rectangle rectangle = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        Graphics graphics = image.getGraphics();
        try {
            Rectangle fillRect;
            if (paintBorder) {
                graphics.setForeground(Color.BLACK);
                graphics.setStroke(Stroke.TWO_SOLID);
                graphics.draw(rectangle);
                fillRect = rectangle.shrink(1);
            } else {
                fillRect = rectangle;
            }
            graphics.setForeground(color);
            graphics.fill(fillRect);
        }
        finally {
            graphics.dispose();
        }
    }

    public static oracle.bpm.ui.Image convertToGrayscale(oracle.bpm.ui.Image source) {
        BufferedImage buffer = new BufferedImage(source.getIconWidth(), source.getIconHeight(), 2);
        buffer.getGraphics().drawImage(source.asAwtImage(), 0, 0, source.getIconWidth(), source.getIconHeight(), null);
        return Utilities.convertToGrayscale(buffer);
    }

    private static oracle.bpm.ui.Image convertToGrayscale(BufferedImage source) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return oracle.bpm.ui.Image.create((Image)op.filter(source, null));
    }
}

