/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.util.StringTokenizer;

public class DrawableTextArea {
    public StringBuffer currentLine;
    public int maxLineWidth;
    public FontMetrics scaledFontMetrics;
    private Color background;
    private transient Point cachedLocation = null;
    private Rectangle cachedRectangle = null;
    private transient String cachedText = null;
    private int columns = 30;
    private boolean drawLines = true;
    private Font font = Font.DIALOG_INPUT;
    private int height;
    private boolean isSelected = false;
    private List<String> lines = new ArrayList<String>();
    private String maxLine = "";
    private int rows;
    private String text;
    private Line2D.Float[] textAreaLines;
    private int width;
    private int x;
    private int y;
    public static final int CHAR_WIDTH = 8;
    private static final int MIN_ROWS = 5;
    private static final int MIN_COLUMNS = 20;
    private static final int TEXT_LEADING = 10;
    public static final int lineOffset = 4;

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public Font getFont() {
        return this.font;
    }

    public Rectangle getBounds() {
        return this.getBoundsForText();
    }

    public void setBounds(Rectangle rect) {
        this.setX(rect.getX());
        this.setY(rect.getY());
        this.setWidth(rect.getWidth());
        this.setHeight(rect.getHeight());
    }

    public void paint(DrawContext context) {
        this.paint(context, true);
    }

    public void paint(DrawContext context, boolean fillBackground) {
        Rectangle rectangle = context.scaleAndInvert(this.getBoundsForText());
        this.paint(context, rectangle, fillBackground);
    }

    public Rectangle getBoundsForText() {
        if (this.hasModifications()) {
            this.lines.clear();
            this.buildLines();
            int currentWidth = 8 * this.maxLine.length();
            currentWidth = currentWidth < this.getMinimumWidth() ? 8 * this.getColumns() : currentWidth;
            int leading = 10;
            int currentHeight = this.lines.size() * 10;
            currentHeight = currentHeight < this.getMinimumHeight() ? this.getRows() * 10 : currentHeight;
            int locX = this.getX();
            int locY = this.getY() + 10;
            this.cachedText = this.getText();
            this.cachedLocation = new Point(this.x, this.y);
            this.cachedRectangle = Rectangle.valueOf((int)locX, (int)locY, (int)currentWidth, (int)(currentHeight += 10));
        }
        return this.cachedRectangle;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Line2D.Float[] getTextAreaLines() {
        return this.textAreaLines;
    }

    public boolean isDrawLines() {
        return this.drawLines;
    }

    public void setDrawLines(boolean drawLines) {
        this.drawLines = drawLines;
    }

    public void paint(DrawContext context, Rectangle rect, boolean fillBackground) {
        Font currentFont = this.getFont();
        Font scaledFont = context.scaleFont(currentFont);
        Graphics graphics = context.getGraphics();
        graphics.setFont(scaledFont);
        this.scaledFontMetrics = graphics.getFontMetrics(scaledFont);
        if (fillBackground) {
            this.fillBackground(context, rect);
        }
        int locY = rect.getY();
        for (String s : this.lines) {
            graphics.drawString(s, rect.getX() + 10, locY += context.scale(10));
        }
        if (this.isDrawLines()) {
            this.drawLines(context, rect);
        }
    }

    private boolean hasModifications() {
        boolean textHasChanged = this.cachedText == null || !this.cachedText.equals(this.getText());
        boolean locationHasChanged = this.cachedLocation == null || this.cachedLocation.getX() != this.x || this.cachedLocation.getY() != this.y;
        return this.cachedRectangle == null || textHasChanged || locationHasChanged;
    }

    private int getMinimumHeight() {
        return 50;
    }

    private int getMinimumWidth() {
        return 160;
    }

    private void drawLines(DrawContext context, Rectangle rectangle) {
        Graphics g = context.getGraphics();
        Stroke stroke = g.getStroke();
        if (this.isSelected()) {
            g.setStroke(Stroke.TWO_SOLID);
        }
        int upperRightX = rectangle.getX() + rectangle.getWidth();
        int upperLeftX = rectangle.getX();
        int upperLeftY = rectangle.getY();
        int bottomLeftY = rectangle.getY() + rectangle.getHeight();
        Line2D.Float[] rectLines = new Line2D.Float[4];
        rectLines[0] = new Line2D.Float(upperLeftX, upperLeftY, upperRightX, upperLeftY);
        rectLines[1] = new Line2D.Float(upperLeftX, bottomLeftY, upperRightX, bottomLeftY);
        rectLines[2] = new Line2D.Float(upperLeftX, upperLeftY, upperLeftX, bottomLeftY);
        this.textAreaLines = rectLines;
        this.textAreaLines[3] = new Line2D.Float(upperRightX, upperLeftY, upperRightX, bottomLeftY);
        if (!context.isPrinting()) {
            g.setStroke(Stroke.ONE_SOLID);
        }
        for (Line2D.Float line : rectLines) {
            g.draw((Shape)line);
        }
        g.setStroke(stroke);
    }

    private void fillBackground(DrawContext context, Rectangle rectangle) {
        Graphics graphics = context.getGraphics();
        Color c = graphics.getForeground();
        graphics.setForeground(Color.WHITE);
        rectangle = Rectangle.valueOf((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        graphics.fill(rectangle);
        graphics.setForeground(c);
    }

    private void buildLines() {
        String theText = this.getText();
        if (theText != null) {
            StringTokenizer st = new StringTokenizer(theText, " ");
            this.currentLine = new StringBuffer("");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.processToken(token);
            }
            if (this.maxLine.length() > this.currentLine.toString().length()) {
                this.maxLine = this.currentLine.toString();
            }
            this.flushLine();
        }
    }

    private void processNewLine(String token) {
        StringTokenizer newLineTokenizer = new StringTokenizer(token, "\n");
        boolean first = true;
        while (newLineTokenizer.hasMoreTokens()) {
            String newLineToken = newLineTokenizer.nextToken();
            if (first) {
                this.processWord(newLineToken);
                first = false;
                continue;
            }
            this.flushLine();
            this.processWord(newLineToken);
        }
    }

    private void processToken(String token) {
        if (token.indexOf(10) != -1) {
            this.processNewLine(token);
            return;
        }
        this.processWord(token);
    }

    private void processWord(String word) {
        String possibleLine = this.currentLine.toString() + " " + word;
        if (possibleLine.length() > this.getColumns()) {
            this.flushLine();
            this.currentLine.append(word);
        } else {
            this.currentLine.append(" ").append(word);
        }
    }

    private void clearLine() {
        this.currentLine.delete(0, this.currentLine.length());
    }

    private void flushLine() {
        this.lines.add(this.currentLine.toString().trim());
        this.clearLine();
    }
}

