/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableConnection;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableFlowNodeImpl;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableNodeContainerImpl;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.draw.renderer.SubprocessRenderer;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableSubprocess
extends DrawableNodeContainerImpl<Subprocess>
implements DrawableFlowNode<Subprocess> {
    private DrawableFlowNodeImpl.ToDrawableConnectionMapper mapper;

    protected DrawableSubprocess(@NotNull DrawableNodeContainer<?> container, @NotNull Subprocess modelObject) {
        super(container, modelObject, DesignerLayer.SUBPROCESS);
        this.mapper = new DrawableFlowNodeImpl.ToDrawableConnectionMapper(container);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle, @NotNull DrawContext context) {
        return !this.isHidden(context) && this.getBounds(context).expand(1).intersects(rectangle);
    }

    @Override
    @NotNull
    public DrawableNodeContainer getContainer() {
        return (DrawableNodeContainer)super.getContainer();
    }

    @Override
    @NotNull
    public Sequence<DrawableConnection> getOutgoingConnections() {
        return ((Subprocess)this.getModelObject()).getOutgoingSequenceFlows().map((Function)this.mapper);
    }

    @Override
    @NotNull
    public Sequence<DrawableConnection> getIncomingConnections() {
        return ((Subprocess)this.getModelObject()).getIncomingSequenceFlows().map((Function)this.mapper);
    }

    @Override
    public void refresh(@NotNull DrawContext context, @Nullable ProjectEvent event) {
        super.refresh(context, event);
        this.setLocation(((Subprocess)this.getModelObject()).getLocation());
        this.setWidth(context, ((Subprocess)this.getModelObject()).getWidth());
        this.setHeight(context, ((Subprocess)this.getModelObject()).getHeight());
    }

    @Override
    protected Renderer createRenderer() {
        return SubprocessRenderer.create((Drawable<Subprocess>)this);
    }
}

