/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DrawableObjectsHolder {
    private final Map<FlowElement, DrawableFlowElement> byElement;
    private final EnumMap<DesignerLayer, TreeSet<DrawableFlowElement>> byLayer = new EnumMap(DesignerLayer.class);

    private DrawableObjectsHolder() {
        this.byElement = new IdentityHashMap<FlowElement, DrawableFlowElement>();
    }

    public static DrawableObjectsHolder create() {
        return new DrawableObjectsHolder();
    }

    public boolean add(@NotNull DrawableFlowElement drawable) {
        if (!DesignerLayer.shouldSkipController(drawable.getLayer())) {
            this.byElement.put((FlowElement)drawable.getModelObject(), drawable);
        }
        return this.getDrawableTreeSet(drawable.getLayer()).add(drawable);
    }

    public boolean remove(@NotNull DrawableFlowElement drawable) {
        if (!DesignerLayer.shouldSkipController(drawable.getLayer())) {
            this.byElement.remove(drawable.getModelObject());
        }
        return this.getDrawableTreeSet(drawable.getLayer()).remove(drawable);
    }

    public boolean contains(@NotNull DrawableFlowElement drawable) {
        return this.getDrawableTreeSet(drawable.getLayer()).contains(drawable);
    }

    public boolean contains(@NotNull FlowElement element) {
        return this.byElement.containsKey(element);
    }

    public void clear() {
        for (TreeSet<DrawableFlowElement> set : this.byLayer.values()) {
            set.clear();
        }
        this.byLayer.clear();
        this.byElement.clear();
    }

    @NotNull
    public Sequence<DrawableFlowElement> getAll() {
        SequenceBuilder sequence = SequenceBuilder.create();
        for (TreeSet<DrawableFlowElement> set : this.byLayer.values()) {
            sequence.append(set);
        }
        return sequence.build();
    }

    @NotNull
    public Sequence<DrawableFlowElement> getAtLayer(@NotNull DesignerLayer layer) {
        return CollectionUtils.asSequence(this.getDrawableTreeSet(layer));
    }

    @NotNull
    public Sequence<DrawableFlowElement> getAtLayers(@NotNull EnumSet<DesignerLayer> layers) {
        SequenceBuilder sequence = SequenceBuilder.create();
        for (DesignerLayer layer : layers) {
            sequence.append(this.getDrawableTreeSet(layer));
        }
        return sequence.build();
    }

    @Nullable
    public DrawableFlowElement getDrawableFor(@NotNull FlowElement element) {
        return this.byElement.get(element);
    }

    @NotNull
    private TreeSet<DrawableFlowElement> getDrawableTreeSet(@NotNull DesignerLayer layer) {
        TreeSet<DrawableFlowElement> result;
        if (!this.byLayer.containsKey((Object)layer)) {
            result = new TreeSet<DrawableFlowElement>(new ReverseDrawableObjectComparator());
            this.byLayer.put(layer, result);
        } else {
            result = this.byLayer.get((Object)layer);
        }
        return result;
    }

    private static class ReverseDrawableObjectComparator
    implements Comparator<DrawableFlowElement> {
        private ReverseDrawableObjectComparator() {
        }

        @Override
        public int compare(DrawableFlowElement d1, DrawableFlowElement d2) {
            int ret = d2.getLayer().ordinal() - d1.getLayer().ordinal();
            return ret != 0 ? ret : d1.compareTo(d2);
        }
    }
}

