/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.text.NonScrollTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableNote
extends DrawableFlowElementImpl<TextAnnotation> {
    private NonScrollTextArea area;
    private GeneralPath arrow = new GeneralPath();
    private Font font;
    public static final Insets TEXT_AREA_CROP = new Insets(5, 5, 10, 10);

    protected DrawableNote(@NotNull DrawableNodeContainer<?> container, @NotNull TextAnnotation textAnnotation) {
        super(container, textAnnotation, DesignerLayer.NOTE);
        this.createTextArea();
        this.setupSizesFromModelNote();
    }

    @Override
    public boolean isHidden(@NotNull DrawContext context) {
        return super.isHidden(context) || !context.getShowNotes();
    }

    @Override
    public boolean contains(int x, int y, @NotNull DrawContext context) {
        return !this.isHidden(context) && super.contains(x, y, context);
    }

    @Override
    public void draw(@NotNull DrawContext context) {
        if (!this.isHidden(context)) {
            this.drawArrowToTarget(context);
            Rectangle scaledBounds = context.scaleRectangle(this.getBounds(context));
            this.area.setText(((TextAnnotation)this.getModelObject()).getDefaultLabel());
            float scale = context.getScale();
            this.area.setFont(this.font.scale(scale));
            Rectangle crop = scaledBounds.shrink(TEXT_AREA_CROP.scaled(scale));
            this.area.setBounds(crop);
            Graphics graphics = context.getGraphics();
            graphics.setForeground(Color.BLACK);
            this.drawBorderAndBackground(scaledBounds, graphics);
            context.paintComponent((UiComponent)this.area, crop);
            super.draw(context);
        }
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle, @NotNull DrawContext context) {
        return super.intersects(rectangle, context) || this.arrow.intersects(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    @Override
    @NotNull
    public DrawableNodeContainer getContainer() {
        return (DrawableNodeContainer)super.getContainer();
    }

    @Override
    public void refresh(@NotNull DrawContext context, @Nullable ProjectEvent event) {
        super.refresh(context, event);
        this.setLocation(((TextAnnotation)this.getModelObject()).getLocation());
        this.setWidth(context, ((TextAnnotation)this.getModelObject()).getWidth());
        this.setHeight(context, ((TextAnnotation)this.getModelObject()).getHeight());
    }

    private void drawBorderAndBackground(@NotNull Rectangle bounds, @NotNull Graphics graphics) {
        Stroke original = graphics.getStroke();
        Color initial = graphics.getForeground();
        Rectangle shrinked = bounds.shrink(1);
        graphics.setForeground(Color.TRANSLUCENT);
        graphics.fill(shrinked);
        graphics.setStroke(Stroke.THREE_SOLID);
        graphics.setForeground(Color.FUEGO_LIGHT_BLUE);
        Point origin = shrinked.getOrigin();
        Point top = shrinked.getTop();
        graphics.drawLine(origin.getX(), origin.getY(), top.getX(), origin.getY());
        graphics.drawLine(origin.getX(), origin.getY(), origin.getX(), top.getY());
        graphics.setForeground(Color.LIGHT_GRAY);
        graphics.drawLine(top.getX(), top.getY(), origin.getX(), top.getY());
        graphics.drawLine(top.getX(), top.getY(), top.getX(), origin.getY());
        graphics.setStroke(this.isShowSelection() ? Stroke.TWO_SOLID : Stroke.ONE_SOLID);
        graphics.setForeground(Color.BLACK);
        graphics.draw(bounds);
        graphics.setForeground(initial);
        graphics.setStroke(original);
    }

    private void drawArrowToTarget(DrawContext context) {
        if (((TextAnnotation)this.getModelObject()).getTarget() != null) {
            Point scaledFrom = context.scalePoint(this.getLocation());
            Point scaledTo = context.scalePoint(((TextAnnotation)this.getModelObject()).getTarget().getLocation());
            Line path = new Line(scaledFrom, scaledTo);
            double fromTime = DrawableHelper.outbound(context, this, (Path)path, true);
            double toTime = DrawableHelper.outbound(context, this.getContainer().asDrawable(((TextAnnotation)this.getModelObject()).getTarget()), (Path)path, false);
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            graphics.setForeground(Color.GRAY.brighter());
            graphics.setAntialiasing(AntialiasingMode.ON);
            Point from = new Point(path.eval(fromTime));
            Point to = new Point(path.eval(toTime));
            this.drawArrowImproved(context, from, to);
            graphics.fillOval(from.getX(), from.getY(), context.scale(3), context.scale(3));
            graphics.setForeground(original);
            graphics.setAntialiasing(AntialiasingMode.OFF);
        }
    }

    private void drawArrowImproved(DrawContext context, Point pFrom, Point pTo) {
        double alfa;
        double toX = pTo.getX();
        double fromX = pFrom.getX();
        double toY = pTo.getY();
        double fromY = pFrom.getY();
        double dx = toX - fromX;
        double dy = toY - fromY;
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        if (dx == 0.0) {
            alfa = dy > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else if (dy == 0.0) {
            alfa = dx > 0.0 ? 0.0 : Math.PI;
        } else {
            alfa = Math.atan(dy / dx);
            if (dx < 0.0) {
                alfa += Math.PI;
            }
        }
        double beta = alfa + 1.5707963267948966;
        double gamma = alfa - 1.5707963267948966;
        double dv = context.scale(3);
        Point2D.Double v1 = new Point2D.Double(dv * Math.cos(beta) + fromX, dv * Math.sin(beta) + fromY);
        Point2D.Double v2 = new Point2D.Double(dv * Math.cos(gamma) + fromX, dv * Math.sin(gamma) + fromY);
        Graphics g = context.getGraphics();
        this.arrow = new GeneralPath();
        this.arrow.moveTo((float)toX, pTo.getY());
        this.arrow.lineTo((float)((Point2D)v1).getX(), (float)((Point2D)v1).getY());
        this.arrow.lineTo((float)((Point2D)v2).getX(), (float)((Point2D)v2).getY());
        this.arrow.closePath();
        g.draw((Shape)this.arrow);
        g.fill((Shape)this.arrow);
    }

    private void createTextArea() {
        if (this.area != null) {
            return;
        }
        this.area = new NonScrollTextArea((UiContainer)Ui.getRoot());
        this.area.setOpaque(false);
        this.area.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        this.font = this.area.getFont();
    }

    private void setupSizesFromModelNote() {
        this.setLocation(((TextAnnotation)this.getModelObject()).getLocation());
        this.setWidth(DrawContext.getDefault(), Math.max(((TextAnnotation)this.getModelObject()).getWidth(), TextAnnotationImpl.MINIMUM_SIZE.getWidth()));
        this.setHeight(DrawContext.getDefault(), Math.max(((TextAnnotation)this.getModelObject()).getHeight(), TextAnnotationImpl.MINIMUM_SIZE.getHeight()));
    }
}

