/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableLane;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class DrawableLaneColumn
extends DrawableFlowElementImpl<LaneImpl> {
    private DrawableLane drawableLane;
    public static final int LANE_COLUMN_SIZE = 20000;
    private static final int LANE_COLUMN_STROKE = 10;

    protected DrawableLaneColumn(DrawableLane drawableLane) {
        super(drawableLane.getContainer(), (LaneImpl)drawableLane.getLane().asMutable(), DesignerLayer.LANE_COLUMN);
        this.drawableLane = drawableLane;
    }

    @Override
    public int getWidth(@NotNull DrawContext context) {
        return this.getDrawableLane().getWidth(context);
    }

    @Override
    public int getHeight(@NotNull DrawContext context) {
        return this.getDrawableLane().getHeight(context);
    }

    @Override
    public int getRightBound(@NotNull DrawContext context) {
        return 0;
    }

    @Override
    public int getUnderBound(@NotNull DrawContext context) {
        return 0;
    }

    @Override
    public boolean contains(int X, int Y, @NotNull DrawContext context) {
        Point location = this.getColumnLineBeginLocation(context, -5);
        int x = location.getX();
        int y = location.getY();
        int w = this.getColumnLineWidth(context);
        int h = this.getColumnLineHeight(context);
        return X >= x && Y >= y && X < x + w && Y < y + h;
    }

    @Override
    public void draw(@NotNull DrawContext context) {
        float scale = context.getScale();
        Graphics g = context.getGraphics();
        Color oldForeground = g.getForeground();
        Color color = this.getColumnColor();
        g.setForeground(color);
        Point begin = this.getColumnLineBeginLocation(context, 0).scaled(scale);
        Point end = this.getColumnLineEndLocation(context, 0).scaled(scale);
        if (this.drawableLane.isShowSelection()) {
            Color fuego = Color.FUEGO_LIGHT_BLUE;
            g.setForeground(Color.valueOf((Color)fuego, (int)90));
            Point location = this.getLocation().scaled(scale);
            int columnBackgroundWidth = (int)((float)this.getColumnBackgroundWidth(context) * scale);
            int columnBackgroundHeight = (int)((float)this.getColumnBackgroundHeight(context) * scale);
            g.fillRect(location.getX(), location.getY(), columnBackgroundWidth, columnBackgroundHeight);
            g.setForeground(color);
        }
        g.setForeground(color.brighter());
        Stroke oldStroke = g.getStroke();
        g.setStroke(Stroke.TWO_SOLID);
        g.drawLine(begin.getX(), begin.getY(), end.getX(), end.getY());
        if (context.isPrinting() && ((LaneImpl)this.getModelObject()).getOffset() == 0) {
            if (ModelUtils.isHorizontal(this.getProcess())) {
                g.drawLine(begin.getX(), 0, end.getX(), 0);
            } else {
                g.drawLine(0, begin.getY(), 0, end.getY());
            }
        }
        g.setStroke(oldStroke);
        g.setForeground(oldForeground);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle, @NotNull DrawContext context) {
        boolean horizontal = ModelUtils.isHorizontal(this.getProcess());
        int rO = horizontal ? rectangle.getY() : rectangle.getX();
        int rS = horizontal ? rectangle.getHeight() : rectangle.getWidth();
        int lO = ((LaneImpl)this.getModelObject()).getOffset();
        int lS = ((LaneImpl)this.getModelObject()).getSize();
        return lO + lS >= rO && rO + rS >= lO;
    }

    public String toString() {
        return "Class " + this.getClass().getName() + " Name " + this.getId();
    }

    public DrawableLane getDrawableLane() {
        return this.drawableLane;
    }

    public Lane getLane() {
        return this.getDrawableLane().getLane();
    }

    @Override
    @NotNull
    public Point getLocation() {
        Point location = new Point(((LaneImpl)this.getModelObject()).getOffset(), 25);
        if (ModelUtils.isHorizontal(this.getProcess())) {
            location = location.transposed();
        }
        return location;
    }

    public int getColumnLineWidth(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? 20000 : 10;
    }

    public int getColumnLineHeight(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? 10 : 20000;
    }

    @Override
    public void remove() {
        this.getDrawableLane().remove();
        super.remove();
    }

    protected Color getColumnColor() {
        return Color.GRAY;
    }

    private Point getColumnLineBeginLocation(@NotNull DrawContext context, int deltaOffset) {
        Point location = new Point(((LaneImpl)this.getModelObject()).getOffset() + ((LaneImpl)this.getModelObject()).getSize() + deltaOffset, 0);
        if (context.isHorizontalDrawing()) {
            location = location.transposed();
        }
        return location;
    }

    private Point getColumnLineEndLocation(@NotNull DrawContext context, int deltaOffset) {
        Point location = new Point(((LaneImpl)this.getModelObject()).getOffset() + ((LaneImpl)this.getModelObject()).getSize() + deltaOffset, 20000);
        if (context.isHorizontalDrawing()) {
            location = location.transposed();
        }
        return location;
    }

    private int getColumnBackgroundWidth(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? 20000 : ((LaneImpl)this.getModelObject()).getSize();
    }

    private int getColumnBackgroundHeight(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? ((LaneImpl)this.getModelObject()).getSize() : 20000;
    }
}

