/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableRoot;
import oracle.bpm.draw.DrawablesHolder;
import oracle.bpm.draw.renderer.DefaultRenderer;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.events.ProjectEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DrawableImpl<T>
implements Drawable<T> {
    private Rectangle bounds;
    private final Drawable container;
    private boolean focus;
    private int height;
    private boolean hidden;
    @NotNull
    private final transient DrawablesHolder<Drawable> holder;
    @NotNull
    private final DesignerLayer layer;
    private Point location = Point.ORIGIN;
    @NotNull
    private final T modelObject;
    @NotNull
    private transient Renderer renderer;
    private boolean selection;
    private final int serialId;
    private int width;

    protected DrawableImpl(Drawable container, @NotNull T modelObject, @NotNull DesignerLayer layer) {
        this.container = container;
        this.modelObject = modelObject;
        this.layer = layer;
        this.holder = this.createHolder();
        this.renderer = this.createRenderer();
        this.serialId = DrawableRoot.nextSerialId();
    }

    @Override
    @NotNull
    public final T getModelObject() {
        return this.modelObject;
    }

    @Override
    @NotNull
    public final DesignerLayer getLayer() {
        return this.layer;
    }

    @Override
    @NotNull
    public Drawable getContainer() {
        return this.container;
    }

    @Override
    public void setRenderer(@NotNull Renderer renderer) {
        this.renderer = renderer;
    }

    @Override
    @NotNull
    public Renderer getRenderer() {
        return this.renderer;
    }

    @NotNull
    public DrawablesHolder getHolder() {
        return this.holder;
    }

    @Override
    public void draw(@NotNull DrawContext context) {
        this.renderer.render(context);
    }

    @Override
    public final int getSerialId() {
        return this.serialId;
    }

    @Override
    @NotNull
    public Rectangle getBounds(@NotNull DrawContext context) {
        if (this.needsUpdate()) {
            this.bounds = this.createBounds(context);
        }
        return this.bounds;
    }

    @Override
    public void setLocation(@NotNull Point location) {
        this.location = location;
    }

    @Override
    @NotNull
    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setWidth(@NotNull DrawContext context, int width) {
        this.width = width;
    }

    @Override
    public int getWidth(@NotNull DrawContext context) {
        return this.width;
    }

    @Override
    public void setHeight(@NotNull DrawContext context, int height) {
        this.height = height;
    }

    @Override
    public int getHeight(@NotNull DrawContext context) {
        return this.height;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden(@NotNull DrawContext context) {
        return this.hidden;
    }

    @Override
    public String getId() {
        return String.valueOf(this.getSerialId());
    }

    @Override
    public boolean contains(int x, int y, @NotNull DrawContext context) {
        return this.getBounds(context).contains(x, y);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle, @NotNull DrawContext context) {
        return !this.isHidden(context) && this.getBounds(context).intersects(rectangle);
    }

    @Override
    public void setShowFocus(boolean focus) {
        this.focus = focus;
    }

    @Override
    public boolean isShowFocus() {
        return this.focus;
    }

    @Override
    public void setShowSelection(boolean selection) {
        this.selection = selection;
    }

    @Override
    public boolean isShowSelection() {
        return this.selection;
    }

    @Override
    public void add() {
        this.container.addChild(this);
    }

    @Override
    public void remove() {
        this.container.removeChild(this);
    }

    @Override
    @NotNull
    public Sequence<Drawable> getDrawables() {
        return this.holder.getDrawables();
    }

    @Override
    public boolean contains(@NotNull Drawable drawable) {
        return this.holder.contains(drawable);
    }

    @Override
    public Drawable getDrawableFor(@NotNull Object element) {
        return this.holder.getDrawableFor(element);
    }

    @Override
    public void addChild(@NotNull Drawable drawable) {
        this.holder.add(drawable);
    }

    @Override
    public void removeChild(@NotNull Drawable drawable) {
        this.holder.remove(drawable);
    }

    @Override
    public int compareTo(Drawable other) {
        return this.getSerialId() - other.getSerialId();
    }

    @Override
    public void refresh(@NotNull DrawContext context, @Nullable ProjectEvent event) {
    }

    protected boolean needsUpdate() {
        return this.bounds == null || this.bounds.getWidth() != this.width || this.bounds.getHeight() != this.height || !this.bounds.getCenter().equals((Object)this.location);
    }

    protected Rectangle createBounds(@NotNull DrawContext context) {
        return Rectangle.createAround((Point)this.getLocation(), (int)this.getWidth(context), (int)this.getHeight(context));
    }

    protected DrawablesHolder<Drawable> createHolder() {
        return DrawablesHolder.create();
    }

    protected Renderer createRenderer() {
        return DefaultRenderer.create(this);
    }
}

