/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableConnection;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableLabel;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.renderer.FlowElementImageRenderer;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DrawableFlowNodeImpl<T extends FlowNode>
extends DrawableFlowElementImpl<T>
implements DrawableFlowNode<T> {
    private DrawableLabel<T> label;
    private final ToDrawableConnectionMapper mapper;

    protected DrawableFlowNodeImpl(@NotNull DrawableNodeContainer<?> container, @NotNull T modelObject, @NotNull DesignerLayer layer) {
        super(container, modelObject, layer);
        this.mapper = new ToDrawableConnectionMapper(container);
        this.label = DrawableLabel.create(container, this);
    }

    @Override
    @NotNull
    public DrawableNodeContainer getContainer() {
        return (DrawableNodeContainer)super.getContainer();
    }

    @Override
    public final void draw(@NotNull DrawContext context) {
        this.getRenderer().render(context);
    }

    @Override
    public final boolean contains(int x, int y, @NotNull DrawContext context) {
        return this.getRenderer().contains(x, y, context);
    }

    @Override
    @NotNull
    public FlowElementRenderer getRenderer() {
        return (FlowElementRenderer)super.getRenderer();
    }

    @Override
    @NotNull
    public Sequence<DrawableConnection> getOutgoingConnections() {
        return ((FlowNode)this.getModelObject()).getOutgoingSequenceFlows().map((Function)this.mapper);
    }

    @Override
    @NotNull
    public Sequence<DrawableConnection> getIncomingConnections() {
        return ((FlowNode)this.getModelObject()).getIncomingSequenceFlows().map((Function)this.mapper);
    }

    @Override
    public void refresh(@NotNull DrawContext context, @Nullable ProjectEvent event) {
        super.refresh(context, event);
        this.setLocation(((FlowNode)this.getModelObject()).getLocation());
        Dimension size = this.getRenderer().getRenderDimension(context);
        this.setWidth(context, size.getWidth());
        this.setHeight(context, size.getHeight());
    }

    @Override
    public boolean isHidden(@NotNull DrawContext context) {
        DrawableFlowElement drawable;
        Subprocess subprocess;
        this.setHidden(false);
        FlowNode node = (FlowNode)this.getModelObject();
        if (!super.isHidden(context) && node.getLane() != null) {
            this.setHidden(node.getLane().isHidden());
        }
        if (!super.isHidden(context) && (subprocess = node.getSubprocess()) != null && (drawable = this.getContainer().getDrawableFor(subprocess)) != null) {
            this.setHidden(drawable.isHidden(context));
            if (!super.isHidden(context)) {
                this.setHidden(ModelUtils.isAnyParentSubprocessCollapsed(node));
            }
        }
        return super.isHidden(context);
    }

    @Override
    public void add() {
        super.add();
        this.label.add();
    }

    @Override
    public void remove() {
        super.remove();
        this.label.remove();
    }

    @Override
    protected Renderer createRenderer() {
        return FlowElementImageRenderer.create(this);
    }

    static class ToDrawableConnectionMapper
    implements Function<SequenceFlow, DrawableConnection> {
        private final DrawableNodeContainer<?> container;

        ToDrawableConnectionMapper(@NotNull DrawableNodeContainer<?> container) {
            this.container = container;
        }

        public DrawableConnection eval(@NotNull SequenceFlow sequenceFlow) {
            return (DrawableConnection)((Object)this.container.asDrawable(sequenceFlow));
        }
    }
}

