/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Shape;
import java.awt.geom.Point2D;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableConnection;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Elbow;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.QuadCurve;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableConnectionImpl<T>
extends DrawableImpl<T>
implements DrawableConnection<T> {
    @NotNull
    final AnchorLocation control;
    @NotNull
    final AnchorLocation source = new AnchorLocation(Point.ORIGIN);
    @NotNull
    final AnchorLocation target = new AnchorLocation(Point.ORIGIN);
    private Path path;
    private static final int ARROW_LENGTH = 10;
    private static final int ARROW_WIDTH = 4;
    private static final int INTERSECTION_TOLERANCE = 12;

    protected DrawableConnectionImpl(Drawable container, @NotNull T modelObject, @NotNull DesignerLayer layer) {
        super(container, modelObject, layer);
        this.control = new AnchorLocation(SequenceFlow.NULL_CONTROL_POINT);
    }

    @Override
    @Nullable
    public Drawable getDrawableSource() {
        return this.source.getDrawable();
    }

    @Override
    @Nullable
    public Drawable getDrawableTarget() {
        return this.target.getDrawable();
    }

    public void setDrawableSource(@NotNull DrawContext context, @NotNull Drawable source) {
        this.source.setDrawable(source);
        this.updatePath(context);
    }

    public void setDrawableTarget(@NotNull DrawContext context, @NotNull Drawable target) {
        this.target.setDrawable(target);
        this.updatePath(context);
    }

    public void setSourceLocation(@NotNull DrawContext context, @NotNull Point source) {
        this.source.setLocation(source);
        this.updatePath(context);
    }

    public void setTargetLocation(@NotNull DrawContext context, @NotNull Point target) {
        this.target.setLocation(target);
        this.updatePath(context);
    }

    public void setControlPointLocation(@NotNull DrawContext context, @NotNull Point control) {
        this.control.setLocation(control);
        this.updatePath(context);
    }

    @Override
    @NotNull
    public Path getPath() {
        if (this.path == null) {
            throw new IllegalStateException("getPath() invoked before shape construction");
        }
        return this.path;
    }

    @Override
    @NotNull
    public Point2D getPathPoint(double t) {
        return this.getPathPoint(this.getPath(), t);
    }

    @Override
    public void draw(@NotNull DrawContext context) {
        Graphics g = context.getGraphics();
        Font previousFont = g.getFont();
        AntialiasingMode mode = g.getAntialiasing();
        g.setAntialiasing(AntialiasingMode.ON);
        this.drawPath(context, this.getPath());
        g.setAntialiasing(mode);
        g.setFont(previousFont);
        g.setForeground(Color.BLACK);
        super.draw(context);
    }

    @Override
    @NotNull
    public Point getControlPoint() {
        return this.control.location;
    }

    @Override
    public boolean contains(int x, int y, @NotNull DrawContext context) {
        this.updatePath(context);
        return this.getPath().intersects(Rectangle.createAround((int)x, (int)y, (int)12));
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle, @NotNull DrawContext context) {
        this.updatePath(context);
        return this.getPath().intersects(rectangle);
    }

    @NotNull
    protected Point2D getPathPoint(@NotNull Path path, double t) {
        return path.eval(t);
    }

    protected void drawOtherDecorations(@NotNull DrawContext context, @NotNull Path path) {
    }

    protected Point getSourceRawLocation() {
        return this.source.getRawLocation();
    }

    protected Point getTargetRawLocation() {
        return this.target.getRawLocation();
    }

    protected void drawPath(@NotNull DrawContext context, @NotNull Path path) {
        Graphics graphics = context.getGraphics();
        Stroke s = graphics.getStroke();
        Color c = graphics.getForeground();
        if (this.isShowSelection()) {
            graphics.setStroke(Stroke.TWO_SOLID);
        }
        Path scaled = path.scaled(context.getScale());
        graphics.draw((Shape)scaled);
        this.drawArrow(context, scaled);
        this.drawOtherDecorations(context, scaled);
        graphics.setStroke(s);
        graphics.setForeground(c);
    }

    protected void drawArrow(@NotNull DrawContext context, @NotNull Path path) {
        Graphics graphics = context.getGraphics();
        Point2D p2 = this.getPathPoint(path, 1.0);
        double arrowLength = context.scale(10);
        Point2D p1 = path.findPointBackwards(p2, arrowLength, 1.0);
        graphics.drawArrow(p1.getX(), p1.getY(), p2.getX(), p2.getY(), context.scale(4));
    }

    void updatePath(@NotNull DrawContext context) {
        Point begin = this.source.getRawLocation();
        Point end = this.target.getRawLocation();
        SequenceFlow flow = (SequenceFlow)this.getModelObject();
        Line result = flow.getRoutingMode() == RoutingMode.STRAIGHT || this.control.isNull() ? new Line(begin, end) : (flow.getRoutingMode() == RoutingMode.ORTHOGONAL ? new Elbow(begin, this.control.getRawLocation(), end) : new QuadCurve(begin, this.control.getRawLocation(), end));
        double t0 = 0.0;
        double t1 = 1.0;
        if (this.source.getDrawable() != null) {
            t0 = DrawableHelper.outbound(context, this.source.getDrawable(), (Path)result, true);
            begin = new Point(this.getPathPoint((Path)result, t0));
        }
        if (this.target.getDrawable() != null) {
            t1 = DrawableHelper.outbound(context, this.target.getDrawable(), (Path)result, false);
            end = new Point(this.getPathPoint((Path)result, t1));
        }
        result = flow.getRoutingMode() == RoutingMode.STRAIGHT || this.control.isNull() ? new Line(begin, end) : (flow.getRoutingMode() == RoutingMode.ORTHOGONAL ? ((Elbow)result).crop(t0, t1) : QuadCurve.createFromMiddlePoint((Point)begin, (Point)new Point(this.getPathPoint((Path)result, 0.5)), (Point)end));
        this.path = result;
        this.updateBoundsForPath(context);
    }

    private void updateBoundsForPath(@NotNull DrawContext context) {
        Rectangle bounds = new Rectangle(this.path.getBounds2D()).expand(2);
        this.setLocation(bounds.getCenter());
        this.setWidth(context, bounds.getWidth());
        this.setHeight(context, bounds.getHeight());
    }

    static class AnchorLocation {
        private Drawable drawable;
        private Point location;

        private AnchorLocation(@NotNull Point location) {
            this.location = location;
        }

        public Point getRawLocation() {
            return this.location != null ? this.location : this.drawable.getLocation();
        }

        public void setDrawable(@NotNull Drawable drawable) {
            this.drawable = drawable;
            this.location = null;
        }

        public void setLocation(@NotNull Point location) {
            this.location = location;
            this.drawable = null;
        }

        private Drawable getDrawable() {
            return this.drawable;
        }

        private boolean isNull() {
            return this.location != null && this.location.equals((Object)SequenceFlow.NULL_CONTROL_POINT);
        }
    }
}

