/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.ArrayList;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableActivity;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.DrawableFactory;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableGateway;
import oracle.bpm.draw.DrawableLane;
import oracle.bpm.draw.DrawableMeasurement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableNote;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableRoot;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class BpmnDrawableFactory
extends DrawableFactory {
    private static BpmnDrawableFactory instance;

    private BpmnDrawableFactory() {
    }

    public static BpmnDrawableFactory getInstance() {
        if (instance == null) {
            instance = new BpmnDrawableFactory();
        }
        return instance;
    }

    @Override
    @NotNull
    public DrawableFlowElement create(Drawable container, @NotNull Object element) {
        DrawableFlowElement<Process> result;
        if (element instanceof Process) {
            result = BpmnDrawableFactory.createProcess((DrawableRoot)container, (Process)element);
        } else if (element instanceof Lane) {
            result = BpmnDrawableFactory.createLane((DrawableNodeContainer)container, (LaneImpl)element);
        } else if (element instanceof SequenceFlow) {
            result = BpmnDrawableFactory.createTransition((DrawableNodeContainer)container, (SequenceFlow)((SequenceFlowImpl)element));
        } else if (element instanceof Measurement) {
            result = BpmnDrawableFactory.createMeasurement((DrawableNodeContainer)container, (Measurement)element);
        } else if (element instanceof TextAnnotation) {
            result = BpmnDrawableFactory.createNote((DrawableNodeContainer)container, (TextAnnotation)element);
        } else if (element instanceof Subprocess) {
            result = BpmnDrawableFactory.createSubprocess((DrawableNodeContainer)container, (Subprocess)element);
        } else if (element instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)element;
            result = flowNode.isEvent() ? BpmnDrawableFactory.createEvent((DrawableNodeContainer)container, flowNode.asAnyNode(Event.class)) : (flowNode.isGateway() ? BpmnDrawableFactory.createGateway((DrawableNodeContainer)container, flowNode.asAnyNode(Gateway.class)) : BpmnDrawableFactory.createActivity((DrawableNodeContainer)container, flowNode.asAnyNode(Activity.class)));
        } else {
            throw new IllegalArgumentException("Drawable Object Creation: Unknown drawable for " + element.getClass() + "!");
        }
        return result;
    }

    @Override
    @NotNull
    public Iterable<?> getChildren(@NotNull Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (object instanceof NodeContainer) {
            NodeContainer container = (NodeContainer)object;
            if (!(object instanceof Subprocess) || !ModelUtils.isCollapsed((Subprocess)object)) {
                for (FlowNode node : container.getFlowNodes()) {
                    result.add(node);
                    if (!node.isActivity()) continue;
                    for (BoundaryEvent boundaryEvent : node.asAnyNode(Activity.class).getActivityBoundaryEvents()) {
                        result.add(boundaryEvent);
                    }
                }
                for (SequenceFlow flow : container.getSequenceFlows()) {
                    result.add(flow);
                }
                for (Measurement measurement : container.getMeasurements()) {
                    result.add(measurement);
                }
            }
            if (container instanceof Process) {
                Process process = (Process)container;
                for (Lane lane : process.getLanes()) {
                    result.add(lane);
                }
                for (TextAnnotation note : process.getTextAnnotations()) {
                    result.add(note);
                }
            }
        }
        return result;
    }

    @NotNull
    private static DrawableProcess createProcess(@NotNull DrawableRoot root, @NotNull Process process) {
        return new DrawableProcess(root, process);
    }

    @NotNull
    private static DrawableSequenceFlow createTransition(@NotNull DrawableNodeContainer container, @NotNull SequenceFlow sequenceFlow) {
        return new DrawableSequenceFlow(container, sequenceFlow);
    }

    @NotNull
    private static DrawableNote createNote(@NotNull DrawableNodeContainer container, @NotNull TextAnnotation textAnnotation) {
        return new DrawableNote(container, textAnnotation);
    }

    @NotNull
    private static DrawableLane createLane(@NotNull DrawableNodeContainer container, @NotNull LaneImpl lane) {
        return new DrawableLane(container, lane);
    }

    @NotNull
    private static DrawableMeasurement createMeasurement(@NotNull DrawableNodeContainer container, @NotNull Measurement measurement) {
        return new DrawableMeasurement(container, measurement);
    }

    @NotNull
    private static DrawableFlowElement createSubprocess(@NotNull DrawableNodeContainer container, @NotNull Subprocess subprocess) {
        DrawableFlowElementImpl result = ModelUtils.isCollapsed(subprocess) ? BpmnDrawableFactory.createActivity(container, subprocess) : new DrawableSubprocess(container, subprocess);
        return result;
    }

    @NotNull
    private static DrawableEvent createEvent(@NotNull DrawableNodeContainer container, @NotNull Event event) {
        return new DrawableEvent(container, event);
    }

    @NotNull
    private static DrawableGateway createGateway(@NotNull DrawableNodeContainer container, @NotNull Gateway gateway) {
        return new DrawableGateway(container, gateway);
    }

    @NotNull
    private static DrawableActivity createActivity(@NotNull DrawableNodeContainer container, @NotNull Activity activity) {
        return new DrawableActivity(container, activity);
    }
}

