/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.wizard;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.studio.Product;
import oracle.bpm.fusion.studio.wizard.AbstractNewProjectObjectWizard;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.text.ValidFileTextField;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.wizard.project.ProjectWizardLauncher;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;

public class NewBpmProjectWizard
extends AbstractNewProjectObjectWizard {
    public NewBpmProjectWizard() {
        this(DesignerMsg.NEW_PROJECT);
    }

    protected NewBpmProjectWizard(Msg title) {
        super(title);
    }

    @Override
    public boolean isAvailable(Context context) {
        return context != null && context.getWorkspace() != null;
    }

    public boolean invoke(Context context) {
        final StringBuilder sb = new StringBuilder();
        context.setProject(null);
        Project project = null;
        final Workspace workspace = context.getWorkspace();
        if (Product.isBPMStudio()) {
            NewProjectDialog dialog = new NewProjectDialog(null, workspace);
            dialog.setVisible(true);
            if (dialog.userAccepted()) {
                URL url = dialog.getProjectURL();
                project = new Project();
                project.setURL(url);
            }
        } else {
            ProjectWizardLauncher launcher = new ProjectWizardLauncher(context, "Creates BPM Project");
            launcher.setShowStepNumber(true);
            launcher.addPage("oracle.bpm.fusion.studio.wizard.ProjectLocationPanel", this.getContextualHelpId());
            project = launcher.runWizard();
        }
        final StatusGlassPane glassPane = new StatusGlassPane((Component)Ide.getMainWindow().getContentPane());
        final Project p = project;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Exception e;
                block15: {
                    e = null;
                    try {
                        if (p == null) break block15;
                        Ide.setActiveProject((Project)p);
                        glassPane.setStatusDetailMessage("Initializing project ..");
                        NewBpmProjectWizard.this.initProject(p);
                        try {
                            p.save();
                            workspace.add((Element)p, true);
                            workspace.save();
                            sb.append("true");
                        }
                        catch (IOException ioe) {
                            System.out.println("### Unable to save project.");
                        }
                    }
                    catch (Exception ex) {
                        try {
                            e = ex;
                        }
                        catch (Throwable throwable) {
                            Runnable r2 = new Runnable(){

                                @Override
                                public void run() {
                                    glassPane.enableUserInput(true);
                                    if (p != null) {
                                        UpdateMessage.fireStructureChanged((Subject)p);
                                    }
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                r2.run();
                            } else {
                                SwingUtilities.invokeLater(r2);
                            }
                            if (e != null) {
                                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                            }
                            throw throwable;
                        }
                        Runnable r2 = new /* invalid duplicate definition of identical inner class */;
                        if (SwingUtilities.isEventDispatchThread()) {
                            r2.run();
                        } else {
                            SwingUtilities.invokeLater(r2);
                        }
                        if (e != null) {
                            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                        }
                    }
                }
                Runnable r2 = new /* invalid duplicate definition of identical inner class */;
                if (SwingUtilities.isEventDispatchThread()) {
                    r2.run();
                } else {
                    SwingUtilities.invokeLater(r2);
                }
                if (e != null) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                }
            }
        };
        glassPane.setStatusMessage("Status", "Creating Project ..");
        glassPane.enableUserInput(false);
        Thread t = new Thread(r);
        t.start();
        return sb.length() != 0;
    }

    protected String getContextualHelpId() {
        return "f1_newbpmproject_html";
    }

    protected void initProject(Project project) {
        ((FusionProjectRepository)AbstractStudioWorkbench.getInstance().getRepository()).setTechnologyScope(project);
    }

    private static class NewProjectDialog
    extends OkCancelDialog {
        private ValidFileTextField nameTextField;
        private Workspace workspace;

        public NewProjectDialog(UiWindow parent, Workspace workspace) {
            super(parent);
            this.workspace = workspace;
            this.init();
        }

        public void ok() {
            URL url = this.getProjectURL();
            if (!URLFileSystem.isBound((URL)url)) {
                this.setVisible(false);
            } else {
                MessageDialog.showError((Msg)DesignerMsg.PROJECT_SAME_NAME_ALREADY_EXISTS);
            }
        }

        public String getProjectName() {
            return this.nameTextField.getText();
        }

        public URL getProjectURL() {
            return this.getProjectURL(this.workspace, this.nameTextField.getText());
        }

        private void init() {
            Panel panel = new Panel(this.getContentPane());
            StandardForm form = FormsFactory.createStandardForm((UiContainer)panel);
            this.nameTextField = new ValidFileTextField((UiContainer)panel, 128);
            this.nameTextField.setText(this.getNextProjectName(this.workspace));
            this.nameTextField.requestFocus();
            form.add(DesignerMsg.NAME, (UiComponent)this.nameTextField);
            this.getContentPane().add((UiComponent)panel, (Object)"Center");
            Msg titleMsg = DesignerMsg.NEW_BPM_PROJECT;
            this.setTitle(titleMsg.getString());
            this.setIconImage(Image.create((Msg)DesignerMsg.NEW_PROJECT));
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }

        private String getNextProjectName(Workspace wksp) {
            String name;
            URL url;
            DefaultNameGenerator nameGen = new DefaultNameGenerator(Project.getDefaultName(), null, 1);
            URL wkspURL = wksp.getURL();
            URL dirURL = URLFileSystem.getParent((URL)wkspURL);
            do {
                if ((url = URLFactory.newURL((URL)dirURL, (String)(name = nameGen.nextName()))) != null) continue;
                return null;
            } while (URLFileSystem.isBound((URL)url));
            return name;
        }

        private URL getProjectURL(Workspace wksp, String projectName) {
            URL wkspURL = wksp.getURL();
            URL dirURL = URLFileSystem.getParent((URL)wkspURL);
            URL projDir = URLFactory.newURL((URL)dirURL, (String)projectName);
            String fName = URLFileSystem.getFileName((URL)projDir);
            if (!URLFileSystem.isDirectoryPath((URL)projDir)) {
                projDir = URLFactory.newDirURL((URL)dirURL, (String)fName);
            }
            return URLFactory.newURL((URL)projDir, (String)(fName + ".jpr"));
        }
    }
}

