/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.views;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.Layout;

public abstract class StudioView
extends DockableWindow {
    private Msg msg;
    private Component ui;
    private static final Image DEFAULT_IMAGE = Image.create((Msg)UIMsg.MANDATORY_FIELD);

    protected StudioView(String viewId, Msg msg) {
        super("BpmStudioView." + viewId);
        this.msg = msg;
    }

    public Component getGUI() {
        if (this.ui == null) {
            UiComponent component = this.createView(UiContainer.NULL);
            this.ui = (Component)component.getNative();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.ui, this.getRealHelpId());
        }
        return this.ui;
    }

    public String getTabName() {
        return this.getMsg().getString();
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 2: {
                this.onHideView();
                return;
            }
            case 3: {
                this.onCloseView();
                return;
            }
            case 1: {
                this.onShowView();
                return;
            }
        }
    }

    public Icon getTabIcon() {
        Msg msg = this.getMsg();
        Image image = Image.create((Msg)msg);
        if (image == null) {
            image = DEFAULT_IMAGE;
        }
        return image.asSwingIcon();
    }

    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    public HelpInfo getHelpInfo() {
        String realHelpId = this.getRealHelpId();
        return new HelpInfo(realHelpId);
    }

    protected abstract UiComponent createView(UiContainer var1);

    protected void onHideView() {
    }

    protected void onCloseView() {
    }

    protected void onShowView() {
    }

    protected Msg getMsg() {
        return this.msg;
    }

    private String getRealHelpId() {
        return Ui.getHelpService().getRealHelpId(this.getId());
    }
}

