/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.views;

import oracle.bpm.adapter.AdapterService;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.catalogdoc.DocumentationEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selection.DesignerSelection;
import oracle.bpm.designer.selection.DesignerSelectionProvider;
import oracle.bpm.fusion.studio.views.StudioView;
import oracle.bpm.lang.Platform;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.util.documentation.Documentable;

public class DocumentationView
extends StudioView {
    private DocumentationCardPanel cardPanel;
    private ProcessResourceListener processResourceListener;
    private SelectionListener processSelectionListener;
    private ProcessDomain selectedProcessDomain;
    private SelectionListener selectionListener;
    public static final String VIEW_ID = "Documentation";

    DocumentationView() {
        super(VIEW_ID, DesignerMsg.DOCUMENTATION);
    }

    public static DocumentationView getInstance() {
        return new DocumentationView();
    }

    @Override
    protected void onHideView() {
        this.stopListening();
    }

    @Override
    protected void onCloseView() {
        this.stopListening();
    }

    @Override
    protected void onShowView() {
        this.startListening();
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        this.cardPanel = new DocumentationCardPanel(parent){

            public String getHelpId() {
                return DocumentationView.this.getId();
            }
        };
        this.processSelectionListener = new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                Documentable documentable = DocumentationView.this.getDocumentableFor(DocumentationView.this.selectedProcessDomain.getDomainElement(), newSelection);
                DocumentationView.this.cardPanel.show(documentable);
            }
        };
        this.processResourceListener = new ProcessResourceListener();
        return this.cardPanel;
    }

    private static SelectionProvider getEditorAreaSelectionProvider() {
        StudioWorkbench studioWorkbench = AbstractStudioWorkbench.getInstance();
        return studioWorkbench.getEditorAreaSelectionProvider();
    }

    private void stopListening() {
        this.stopProcessListening();
        if (this.selectionListener != null) {
            DocumentationView.getEditorAreaSelectionProvider().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    private void stopProcessListening() {
        if (this.selectedProcessDomain != null) {
            this.selectedProcessDomain.getSelectionProvider().removeSelectionListener(this.processSelectionListener);
            this.selectedProcessDomain.getDomainElement().removeListener((ProjectListener)this.processResourceListener);
            this.selectedProcessDomain = null;
        }
    }

    private void startListening() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(){

                public void selectionChanged(Selection newSelection) {
                    DocumentationView.this.editorChanged(newSelection);
                }
            };
            SelectionProvider selectionProvider = DocumentationView.getEditorAreaSelectionProvider();
            selectionProvider.addSelectionListener(this.selectionListener);
            Selection defaultSelection = selectionProvider.getSelection();
            this.editorChanged(defaultSelection);
        }
    }

    private Documentable getDocumentableFor(Process process, Selection designerSelection) {
        FlowNode flowNode = (FlowNode)designerSelection.as(FlowNode.class);
        AdapterService adapterService = Platform.getAdapterService();
        Documentable documentable = flowNode != null ? adapterService.adaptTo(flowNode, Documentable.class) : (process != null ? adapterService.adaptTo(process, Documentable.class) : null);
        return documentable;
    }

    private void editorChanged(Selection newSelection) {
        Process process = (Process)newSelection.as(Process.class);
        this.stopProcessListening();
        Documentable documentable = null;
        if (process != null) {
            this.selectedProcessDomain = Context.getDomainFor((Process)process);
            if (this.selectedProcessDomain != null) {
                process.addListener((ProjectListener)this.processResourceListener);
                DesignerSelectionProvider selectionProvider = this.selectedProcessDomain.getSelectionProvider();
                selectionProvider.addSelectionListener(this.processSelectionListener);
                DesignerSelection designerSelection = selectionProvider.getSelection();
                documentable = this.getDocumentableFor(process, (Selection)designerSelection);
            }
        }
        this.cardPanel.show(documentable);
    }

    private class ProcessResourceListener
    extends ProjectListenerAdapter<Process> {
        public ProcessResourceListener() {
            super(Process.class);
        }

        public void objectChanged(Process process, ProjectEvent event) {
            DocumentationView.this.cardPanel.refreshLabel();
        }
    }

    private static class EmptyDocumentationPanel
    extends Panel {
        public EmptyDocumentationPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("align 50% 50%"));
            Label label = Label.createWithNoColon((UiContainer)this, (Msg)LibMsg.DOCUMENTATION_NOT_AVAILABLE);
            this.add((UiComponent)label);
        }
    }

    private static class DocumentationCardPanel
    extends Panel {
        private DocumentationEditorPanel documentationPanel;
        private static final String EMPTY_EDITOR = "EmptyEditor";
        private static final String DOCUMENTATION_EDITOR = "DocumentationEditor";

        public DocumentationCardPanel(UiContainer parent) {
            super(parent);
            this.setLayout((Layout)new CardLayout());
            EmptyDocumentationPanel emptyDocumentationPanel = new EmptyDocumentationPanel((UiContainer)this);
            this.add((UiComponent)emptyDocumentationPanel, EMPTY_EDITOR);
        }

        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public void show(Documentable documentable) {
            String key;
            if (documentable != null) {
                key = DOCUMENTATION_EDITOR;
                if (this.documentationPanel == null) {
                    this.documentationPanel = DocumentationEditorPanel.createAutosave((Documentable)documentable);
                    this.add(UiComponent.get((Object)this.documentationPanel), DOCUMENTATION_EDITOR);
                } else {
                    this.documentationPanel.documentableChanged(documentable);
                }
            } else {
                key = EMPTY_EDITOR;
            }
            this.getLayout().show((UiContainer)this, key);
        }

        public void refreshLabel() {
            if (this.documentationPanel != null) {
                this.documentationPanel.refreshLabel();
            }
        }
    }
}

