/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.thumbnail;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.tip.tools.ide.common.graph.GraphUtils;

public class ThumbnailOverViewPanel
extends JPanel
implements ChangeListener,
MouseListener,
MouseMotionListener {
    protected boolean m_bPaintDiagramStructure = true;
    protected Rectangle m_scaledViewportRect = new Rectangle();
    protected JScrollPane m_scrollPane;
    protected JViewport m_viewport;
    private Component m_pane;
    private static Font MESSAGE_FONT = null;
    private static Color TRANSPARENT_COLOR = Color.lightGray;

    private ThumbnailOverViewPanel(Component component) {
        this.m_pane = component;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.m_scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.m_pane);
        if (this.m_scrollPane != null) {
            this.m_viewport = this.m_scrollPane.getViewport();
            this.m_viewport.addChangeListener(this);
        }
        this.updateDisplay();
    }

    public static ThumbnailOverViewPanel create(Component component) {
        return new ThumbnailOverViewPanel(component);
    }

    public void updateDisplay() {
        this.computeViewportRect();
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.m_viewport.getView() != null) {
            this.updateViewport();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(13));
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        Dimension scaledDim = this.computeScaledDimension();
        if (y > scaledDim.height || x > scaledDim.width) {
            return;
        }
        Rectangle scaledRect = new Rectangle(0, 0, scaledDim.width, scaledDim.height);
        Point grabPt = this.computeVisibleRectPosition(x, y, scaledRect);
        this.m_scaledViewportRect.x = grabPt.x;
        this.m_scaledViewportRect.y = grabPt.y;
        int xPos = this.m_scaledViewportRect.x - scaledRect.x;
        int yPos = this.m_scaledViewportRect.y - scaledRect.y;
        float pctX = (float)xPos / (float)scaledRect.width;
        float pctY = (float)yPos / (float)scaledRect.height;
        if (this.m_scrollPane != null) {
            JViewport vp = this.m_scrollPane.getViewport();
            Dimension graphDim = vp.getViewSize();
            int graphX = Math.round(pctX * (float)graphDim.width);
            int graphY = Math.round(pctY * (float)graphDim.height);
            vp.setViewPosition(new Point(graphX, graphY));
        }
        this.repaint();
    }

    public synchronized Dimension computeScaledDimension() {
        double scaledGraphPaneWidth;
        double scaledGraphPaneHeight;
        Dimension overviewPanelDim = this.getSize();
        if (this.m_viewport == null || this.m_pane == null) {
            return null;
        }
        Rectangle2D.Double graphPaneRect = new Rectangle2D.Double(0.0, 0.0, this.m_pane.getBounds().width, this.m_pane.getBounds().height);
        if (((RectangularShape)graphPaneRect).getHeight() > ((RectangularShape)graphPaneRect).getWidth()) {
            scaledGraphPaneHeight = overviewPanelDim.height - 1;
            scaledGraphPaneWidth = ((RectangularShape)graphPaneRect).getWidth() / ((RectangularShape)graphPaneRect).getHeight() * scaledGraphPaneHeight;
            while (scaledGraphPaneWidth > (double)overviewPanelDim.width) {
                scaledGraphPaneWidth = ((RectangularShape)graphPaneRect).getWidth() / ((RectangularShape)graphPaneRect).getHeight() * (scaledGraphPaneHeight -= 1.0);
            }
        } else {
            scaledGraphPaneWidth = overviewPanelDim.width - 1;
            scaledGraphPaneHeight = ((RectangularShape)graphPaneRect).getHeight() * scaledGraphPaneWidth / ((RectangularShape)graphPaneRect).getWidth();
            while (scaledGraphPaneHeight > (double)overviewPanelDim.height) {
                scaledGraphPaneHeight = ((RectangularShape)graphPaneRect).getHeight() * (scaledGraphPaneWidth -= 1.0) / ((RectangularShape)graphPaneRect).getWidth();
            }
        }
        return new Dimension((int)scaledGraphPaneWidth, (int)scaledGraphPaneHeight);
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Dimension scaledDim = this.computeScaledDimension();
        if (y > scaledDim.height || x > scaledDim.width) {
            return;
        }
        Rectangle scaledRect = new Rectangle(0, 0, scaledDim.width, scaledDim.height);
        Point grabPt = this.computeVisibleRectPosition(x, y, scaledRect);
        this.m_scaledViewportRect.x = grabPt.x;
        this.m_scaledViewportRect.y = grabPt.y;
        int xPos = this.m_scaledViewportRect.x - scaledRect.x;
        int yPos = this.m_scaledViewportRect.y - scaledRect.y;
        float pctX = (float)xPos / (float)scaledRect.width;
        float pctY = (float)yPos / (float)scaledRect.height;
        if (this.m_scrollPane != null) {
            JViewport vp = this.m_scrollPane.getViewport();
            Component graph = vp.getView();
            Dimension graphDim = graph.getSize();
            int graphX = Math.round(pctX * (float)graphDim.width);
            int graphY = Math.round(pctY * (float)graphDim.height);
            vp.setViewPosition(new Point(graphX, graphY));
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, sz.width, sz.height);
        if (this.m_pane != null) {
            int xOffset;
            int iHeight;
            int iWidth;
            int yOffset = 0;
            if (this.m_viewport.getView() == null) {
                return;
            }
            if (this.getPaintDiagramStructure()) {
                Image i = this.getPaneImage();
                if (i == null) return;
                iWidth = i.getWidth(null);
                iHeight = i.getHeight(null);
                xOffset = Math.max(0, (sz.width - iWidth) / 2);
                g.drawImage(i, xOffset, yOffset, null);
                g.setColor(new Color(148, 150, 148));
                g.drawRect(xOffset, yOffset, iWidth, iHeight);
            } else {
                Dimension scaledDim = this.computeScaledDimension();
                xOffset = Math.max(0, (sz.width - scaledDim.width) / 2);
                iWidth = scaledDim.width;
                iHeight = scaledDim.height;
                g.setColor(Color.white);
                g.fillRect(xOffset, yOffset, iWidth, iHeight);
                g.setColor(Color.black);
                g.drawRect(xOffset, yOffset, iWidth, iHeight);
            }
            if (this.m_scaledViewportRect == null || this.m_scaledViewportRect.height <= 0 || this.m_scaledViewportRect.width <= 0) return;
            Color bg = TRANSPARENT_COLOR;
            Rectangle rect = new Rectangle(xOffset, yOffset, iWidth, this.m_scaledViewportRect.y - yOffset);
            GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
            rect.setBounds(xOffset, this.m_scaledViewportRect.y, this.m_scaledViewportRect.x, yOffset + iHeight - this.m_scaledViewportRect.y);
            GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
            rect.setBounds(xOffset + this.m_scaledViewportRect.x + this.m_scaledViewportRect.width, this.m_scaledViewportRect.y, xOffset + iWidth - (xOffset + this.m_scaledViewportRect.x + this.m_scaledViewportRect.width), yOffset + iHeight - this.m_scaledViewportRect.y);
            GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
            rect.setBounds(xOffset + this.m_scaledViewportRect.x, this.m_scaledViewportRect.y + this.m_scaledViewportRect.height, this.m_scaledViewportRect.width, yOffset + iHeight - (this.m_scaledViewportRect.y + this.m_scaledViewportRect.height));
            GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
            Color c = new Color(192, 192, 192);
            GraphUtils.drawRect((Graphics)g, (int)(this.m_scaledViewportRect.x + xOffset), (int)this.m_scaledViewportRect.y, (int)this.m_scaledViewportRect.width, (int)this.m_scaledViewportRect.height, (int)1, (Color)c);
            return;
        } else {
            g.setColor(Color.lightGray);
            String text = "BPEL Overview Inactive";
            g.setFont(MESSAGE_FONT);
            Font f = g.getFont();
            int strWidth = GraphUtils.getStringWidth((Font)f, (String)text);
            int h = GraphUtils.getFontHeight((Font)f);
            int x = Math.max(0, (this.getWidth() - strWidth) / 2);
            int y = Math.max(0, (this.getHeight() - h) / 2);
            g.drawString(text, x, y);
        }
    }

    public boolean getPaintDiagramStructure() {
        return this.m_bPaintDiagramStructure;
    }

    public void setPaintDiagramStructure(boolean value) {
        this.m_bPaintDiagramStructure = value;
    }

    protected void updateViewport() {
        this.computeViewportRect();
        this.repaint();
    }

    protected void computeViewportRect() {
        if (this.m_viewport == null || this.m_pane == null) {
            this.m_scaledViewportRect.setBounds(0, 0, 0, 0);
            return;
        }
        Rectangle viewPortRect = this.m_viewport.getViewRect();
        Component comp = this.m_viewport.getView();
        Dimension scaledDim = this.computeScaledDimension();
        double pctX = (double)viewPortRect.x / (double)comp.getWidth();
        double scaledViewportX = pctX * scaledDim.getWidth();
        double pctY = (double)viewPortRect.y / (double)comp.getHeight();
        double scaledViewportY = pctY * scaledDim.getHeight();
        double pctWidth = (double)viewPortRect.width / (double)comp.getWidth();
        double scaledViewportWidth = pctWidth * scaledDim.getWidth();
        double pctHeight = (double)viewPortRect.height / (double)comp.getHeight();
        double scaledViewportHeight = pctHeight * scaledDim.getHeight();
        this.m_scaledViewportRect.setBounds((int)scaledViewportX, (int)scaledViewportY, (int)scaledViewportWidth, (int)scaledViewportHeight);
    }

    protected Point computeVisibleRectPosition(int x, int y, Rectangle scaledRect) {
        Dimension sz = this.getSize();
        int xOffset = Math.max(0, (sz.width - scaledRect.width) / 2);
        int xPos = x - xOffset;
        int viewportX = xPos - this.m_scaledViewportRect.width / 2;
        int viewportY = y - this.m_scaledViewportRect.height / 2;
        if (viewportX < scaledRect.x) {
            viewportX = scaledRect.x;
        }
        if (viewportY < scaledRect.y) {
            viewportY = scaledRect.y;
        }
        if (viewportX + this.m_scaledViewportRect.width > scaledRect.x + scaledRect.width) {
            viewportX = Math.max(scaledRect.x, scaledRect.x + scaledRect.width - this.m_scaledViewportRect.width);
        }
        if (viewportY + this.m_scaledViewportRect.height > scaledRect.y + scaledRect.height) {
            viewportY = Math.max(scaledRect.y, scaledRect.y + scaledRect.height - this.m_scaledViewportRect.height);
        }
        return new Point(viewportX, viewportY);
    }

    private Image getPaneImage() {
        Dimension scaledDim = this.computeScaledDimension();
        return this.m_pane.createImage(scaledDim.width, scaledDim.height);
    }

    static {
        MESSAGE_FONT = UIManager.getFont("Label.font");
    }
}

