/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.structure;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.io.IOException;
import java.util.Comparator;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProjectObjectTreeModel;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.fusion.core.model.AbstractContainerNode;
import oracle.bpm.fusion.core.model.ExplorerNodeComparator;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.core.model.TreeNodeAdapter;
import oracle.bpm.fusion.studio.structure.ElementNodeFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.ui.UiUtilities;
import oracle.ide.Context;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.model.Element;
import oracle.ideimpl.explorer.BaseTreeExplorer;

public class BpmStructureExplorer
extends BaseTreeExplorer {
    private ProjectListener<ProjectObject> projectListener;
    private Element rootNode;
    private ProjectObjectTreeModel treeModel;

    public Comparator getExplorerNodeComparator() {
        return new ExplorerNodeComparator();
    }

    public Transferable[] dragStarted(DragGestureEvent event) {
        return super.dragStarted(event);
    }

    public void dropOccurred(DragSourceDropEvent event, Object o) {
        super.dropOccurred(event, o);
        Transferable transferable = event.getDragSourceContext().getTransferable();
        if (transferable.isDataFlavorSupported(TransferableContext.contextFlavor)) {
            try {
                TransferableContext transferableContext = (TransferableContext)event.getDragSourceContext().getTransferable().getTransferData(TransferableContext.contextFlavor);
                Element context = transferableContext.getContext().getElement();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected Element annotate(Context context) {
        return this.createElementForContext(context);
    }

    protected void createDropTarget() {
        super.createDropTarget();
    }

    private Element createElementForContext(Context context) {
        if (context.getNode() instanceof StudioNode) {
            StudioNode node = (StudioNode)context.getNode();
            StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
            if (node.getObject() instanceof ProjectObject) {
                ProjectObject projectObject = (ProjectObject)node.getObject();
                if (projectObject != null && projectObject.is(CatalogModule.class)) {
                    return ElementNodeFactory.getInstance().create(null);
                }
                ProjectObjectTreeNode outlineRootNode = null;
                if (projectObject != null && this.isValid(projectObject)) {
                    outlineRootNode = (ProjectObjectTreeNode)workbench.findOutlineRootNodeForObject((Object)projectObject);
                }
                if (outlineRootNode != null) {
                    if (this.treeModel == null) {
                        this.treeModel = new ProjectObjectTreeModel(outlineRootNode);
                        this.treeModel.setProjectListenerDelegate(this.getProjectListener());
                        this.rootNode = ElementNodeFactory.getInstance().create(outlineRootNode);
                        this.setComparator(this.getExplorerNodeComparator());
                    }
                    return this.rootNode;
                }
            }
        }
        return context.getNode();
    }

    private boolean isValid(ProjectObject projectObject) {
        ProjectObjectContainer parent = (ProjectObjectContainer)projectObject.getParentObject();
        if (parent != null) {
            Sequence children = parent.getChildren();
            for (ProjectObject child : children) {
                if (child != projectObject) continue;
                return true;
            }
        }
        return false;
    }

    private void disposeTreeModel() {
        if (this.treeModel != null) {
            this.removeProjectListenerDelegate();
            this.treeModel.dispose();
        }
    }

    private void removeProjectListenerDelegate() {
        if (this.treeModel != null) {
            this.treeModel.removeProjectListenerDelegate();
        }
    }

    private void reloadRoot() {
        if (this.rootNode instanceof TreeNodeAdapter) {
            TreeNodeAdapter root = (TreeNodeAdapter)this.rootNode;
            root.reloadChildren();
        } else {
            ((AbstractContainerNode)this.rootNode).reloadChildren(null);
        }
        this.refresh(this.getRoot());
    }

    private ProjectListener<ProjectObject> getProjectListener() {
        if (this.projectListener == null) {
            this.projectListener = new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

                public void processPostEvents(final ProjectEventSet events) {
                    if (!UiUtilities.isEventDispatchThread()) {
                        UiUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.processPostEvents(events);
                            }
                        });
                        return;
                    }
                    UiUtilities.assertUiThread();
                    BpmStructureExplorer.this.refresh(BpmStructureExplorer.this.getRoot());
                }
            };
        }
        return this.projectListener;
    }
}

