/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import oracle.bpm.fusion.core.BaseNavigatorWindow;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.fusion.studio.Product;
import oracle.bpm.fusion.studio.StudioPreferences;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.util.FileFilter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.javatools.icons.OracleIcons;

class ProjectNavigatorWindow
extends BaseNavigatorWindow
implements ItemListener {
    private JComboBox combo;
    private JPanel mainPanel;
    private Controller projectNavigatorController = new ProjectNavigatorController();

    ProjectNavigatorWindow(Context context, String viewId) {
        super(context, viewId, FusionStudioMsg.BPM_PROJECT_NAVIGATOR);
    }

    public Component getGUI() {
        Component result;
        if (!Product.isBPMStudio()) {
            result = super.getGUI();
        } else {
            if (this.mainPanel == null) {
                this.mainPanel = this.createMainPanel();
            }
            result = this.mainPanel;
        }
        return result;
    }

    public String getTabName() {
        return FusionStudioMsg.BPM_NAVIGATOR.getString();
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Controller getController() {
        return this.projectNavigatorController;
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace != null) {
            Project currentProject;
            Node node = context.getNode();
            if (node != null && node.getURL() != null) {
                FusionProjectRepository fusionProjectRepository = (FusionProjectRepository)RepositoryService.getInstance().getActiveRepository();
                currentProject = fusionProjectRepository.getJdevProject(node.getURL());
            } else {
                currentProject = currentWorkspace.currentActiveProject();
                context.setNode((Node)currentWorkspace);
            }
            context.setWorkspace(currentWorkspace);
            context.setElement((Element)currentWorkspace);
            context.setProject(currentProject);
        } else {
            context.setWorkspace(null);
            context.setProject(null);
        }
        return context;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item;
        if (e.getStateChange() == 1 && (item = e.getItem()) instanceof ApplicationItem) {
            Workspace workspace = ((ApplicationItem)item).getWorkspace();
            JdevRepositoryService.getInstance().applicationChanged(workspace);
            Ide.setActiveWorkspace((Workspace)workspace);
        }
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        this.combo = new JComboBox();
        this.combo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof ApplicationItem) {
                    String name = ((ApplicationItem)value).getName();
                    return new JLabel(name);
                }
                String s = value != null ? value.toString() : FusionStudioMsg.NO_APPLICATION.getString();
                return new JLabel(s);
            }
        });
        this.combo.addItemListener(this);
        Iterator workspaces = Ide.getWorkspaces().getChildren();
        while (workspaces.hasNext()) {
            Workspace w = (Workspace)workspaces.next();
            this.combo.addItem(new ApplicationItem(w));
        }
        if (Ide.getActiveWorkspace() != null) {
            this.combo.setSelectedItem(new ApplicationItem(Ide.getActiveWorkspace()));
        }
        Icon openAppIcon = OracleIcons.getIcon((String)"application.png");
        Icon newAppIcon = OracleIcons.getIcon((String)"newApplication.png");
        JButton openAppButton = new JButton(openAppIcon);
        openAppButton.setToolTipText(FusionStudioMsg.OPEN_APPLICATION.getString());
        openAppButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProjectNavigatorWindow.this.invokeOpenApplication();
                    }
                });
            }
        });
        JButton createAppButton = new JButton(newAppIcon);
        createAppButton.setToolTipText(FusionStudioMsg.NEW_APPLICATION.getString());
        createAppButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProjectNavigatorWindow.this.invokeCreateNewApplication();
                    }
                });
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.combo);
        toolbar.addSeparator();
        toolbar.add(openAppButton);
        toolbar.add(createAppButton);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)toolbar, "North");
        Component component = super.getGUI();
        mainPanel.add(component, "Center");
        mainPanel.setOpaque(false);
        return mainPanel;
    }

    private void invokeCreateNewApplication() {
        NewWorkspacePanel panel = new NewWorkspacePanel(false, false, true);
        boolean result = panel.runDialog();
        if (result) {
            URL url = panel.getFileURL();
            Workspace workspace = new Workspace();
            workspace.setURL(url);
            try {
                Project p = new Project();
                p.setURL(new URL(url, "BPMProject1"));
                workspace.add((Element)p);
                workspace.save();
                workspace.remove((Element)p);
                workspace.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.selectWorkspace(workspace);
        }
    }

    private void invokeOpenApplication() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(FileFilter.create(FusionStudioMsg.APPLICATION_FILE, ".jws"));
        chooser.setSelectedFile(new File(Ide.getWorkDirectory()));
        int result = chooser.showOpenDialog(null);
        if (result == 0) {
            File selectedFile = chooser.getSelectedFile();
            String app = selectedFile.getName();
            try {
                Workspace workspace = new Workspace();
                workspace.setURL(selectedFile.toURI().toURL());
                workspace.open();
                this.selectWorkspace(workspace);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void selectWorkspace(Workspace workspace) {
        Ide.getWorkspaces().add((Element)workspace);
        Ide.setActiveWorkspace((Workspace)workspace);
        this.updatePreferences();
        JdevRepositoryService.getInstance().applicationChanged(workspace);
        ApplicationItem item = new ApplicationItem(workspace);
        this.combo.setToolTipText(workspace.getURL().toString());
        this.combo.addItem(item);
        this.combo.setSelectedItem(item);
        IdeMainWindow.updateVisibleActions();
    }

    private void updatePreferences() {
        StudioPreferences studioPreferences = StudioPreferences.getPreferences();
        studioPreferences.setActiveWorkspace(Ide.getActiveWorkspace().getURL().toString());
        Iterator children = Ide.getWorkspaces().getChildren();
        studioPreferences.getWorkspaces().clear();
        while (children.hasNext()) {
            studioPreferences.getWorkspaces().add(((Workspace)children.next()).getURL().toString());
        }
        studioPreferences.store();
    }

    private final class ProjectNavigatorController
    implements Controller {
        private ProjectNavigatorController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }

    private final class ApplicationItem {
        private Workspace workspace;

        public ApplicationItem(Workspace workspace) {
            this.workspace = workspace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationItem that = (ApplicationItem)o;
            return !(this.workspace != null ? !this.workspace.getURL().equals(that.workspace.getURL()) : that.workspace != null);
        }

        public int hashCode() {
            return this.workspace != null ? this.workspace.getURL().hashCode() : 0;
        }

        public String getName() {
            String name = this.workspace.getShortLabel();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
            return name;
        }

        public Workspace getWorkspace() {
            return this.workspace;
        }
    }
}

