/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.navigator;

import java.awt.Component;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.action.ReloadCatalogAction;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.core.model.DefaultRootChildrenResolver;
import oracle.bpm.fusion.core.model.DefaultRootNode;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.core.model.StudioNodeFactory;
import oracle.bpm.fusion.studio.Product;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.fusion.studio.navigator.AbstractRepositoryNavigatorManager;
import oracle.bpm.fusion.studio.navigator.ProjectNavigatorChildrenResolver;
import oracle.bpm.fusion.studio.navigator.ProjectNavigatorWindow;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryChangeEvent;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.RepositoryServiceListener;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class ProjectNavigatorManager
extends AbstractRepositoryNavigatorManager {
    private ProjectNavigatorChildrenResolver childrenResolver;
    private ProjectListener<ProjectObject> projectListener;
    private RepositoryServiceListener repositoryServiceListener;
    private ProjectNavigatorTree tree;
    private static ProjectNavigatorManager instance;
    public static final String NAVIGATOR_WINDOW_ID = "BPMProjectNavigator";
    private static final String NAVIGATOR_KEY = "DEFAULT";

    private ProjectNavigatorManager() {
        super(RepositoryService.getInstance().getActiveRepository());
        RepositoryService.getInstance().addObserver(this.getRepositoryServiceListener());
        ReloadCatalogAction.setReloader((ReloadCatalogAction.Reloader)new ReloadCatalogAction.Reloader(){

            public void reload() {
                ProjectNavigatorManager.this.reloadTree();
            }
        });
        Menubar menuMgr = Ide.getMenubar();
        IdeAction showAction = this.getShowAction();
        JMenuItem navigatorMenuItem = menuMgr.createMenuItem((ToggleAction)showAction);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        menuMgr.add((Component)navigatorMenuItem, viewMenu, MenuConstants.SECTION_VIEW_ADDINS);
    }

    public static synchronized ProjectNavigatorManager getInstance() {
        if (instance == null) {
            instance = new ProjectNavigatorManager();
        }
        return instance;
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)Ide.findOrCreateCmdID((String)"fusion.studio.showProjectNavigator"), null, (String)FusionStudioMsg.BPM_PROJECT_NAVIGATOR.toString(), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, null, (Icon)Image.create((Msg)FusionStudioMsg.BPM_PROJECT_NAVIGATOR).asSwingIcon(), null, (boolean)true);
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)this.getRootNode(), false, 1);
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new ProjectNavigatorWindow(context, viewId.getId());
    }

    protected String getDefaultName() {
        return NAVIGATOR_WINDOW_ID;
    }

    protected String getViewCategory() {
        return "BpmStudioViewDEFAULT";
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam param = super.createNavigatorDockingParam();
        if (!Product.isBPMStudio()) {
            DockStation ds = DockStation.getDockStation();
            NavigatorManager navigator = NavigatorManager.getApplicationNavigatorManager();
            ViewId viewId = navigator.getDefaultViewId();
            Dockable d = ds.findDockable(viewId);
            param.setPosition(d, 4, 0);
        } else {
            Dockable dockable = (Dockable)ExplorerManager.getExplorerManager().getViews().iterator().next();
            param.setPosition(dockable, 2, 0);
        }
        return param;
    }

    protected StudioNode createRootNode() {
        this.tree = ProjectNavigatorTree.create((UiContainer)Ui.getRoot(), (ProjectFilter)this.getProjectFilter(), (ProjectRepository)this.getProjectRepository());
        this.tree.setAsApplicationTree();
        AbstractStudioWorkbench.getInstance().setProjectTree(this.tree);
        ProjectObjectTreeNode rootNode = this.tree.getRoot();
        this.tree.setProjectListenerDelegate(this.getProjectListener());
        StudioNodeFactory nodeFactory = new StudioNodeFactory();
        this.childrenResolver = ProjectNavigatorChildrenResolver.getInstance((TreeNode)rootNode, (oracle.bpm.fusion.core.model.NodeFactory<Project, TreeNode>)nodeFactory);
        DefaultRootNode defaultRootNode = new DefaultRootNode((Object)rootNode, rootNode.getMsg(), (DefaultRootChildrenResolver)this.childrenResolver);
        defaultRootNode.setURL(StudioNodeFactory.calculateURL((TreeNode)rootNode));
        return defaultRootNode;
    }

    protected Iterable<StudioNode> getChildren() {
        return this.childrenResolver.getChildren();
    }

    private RepositoryServiceListener getRepositoryServiceListener() {
        if (this.repositoryServiceListener == null) {
            this.repositoryServiceListener = new RepositoryServiceListener(){

                public void repositoryChanged(RepositoryChangeEvent event) {
                    ProjectNavigatorManager.this.tree.changeRepository(event.getNewProjectRepository());
                    ProjectNavigatorManager.this.changeProjectRepository(event.getNewProjectRepository());
                }
            };
        }
        return this.repositoryServiceListener;
    }

    private ProjectListener<ProjectObject> getProjectListener() {
        if (this.projectListener == null) {
            this.projectListener = new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

                public void processPostEvents(final ProjectEventSet events) {
                    if (!UiUtilities.isEventDispatchThread()) {
                        UiUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.processPostEvents(events);
                            }
                        });
                        return;
                    }
                    for (ProjectEvent event : events) {
                        StudioNode<ProjectObject> node;
                        ProjectObject projectObject = event.getProjectObject();
                        if (event.getType() == ProjectEvent.Type.CHANGE) {
                            Project project;
                            StudioNode<ProjectObject> studioNode;
                            node = ProjectNavigatorManager.this.findNode(projectObject);
                            if (node != null) {
                                node.invalidateIcon();
                                node.ensureOpen();
                                if (projectObject instanceof ResourceObject) {
                                    node.markDirty(((ResourceObject)projectObject).isDirty());
                                    IdeActions.getFileSaveAction().updateAction();
                                }
                                UpdateMessage message1 = new UpdateMessage(UpdateMessage.CHILD_RENAMED, node);
                                node.notifyObservers(node, message1);
                                UpdateMessage message = new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, node);
                                node.notifyObservers(node, message);
                                if (!"swap_children".equals(event.getPropertyName())) continue;
                                int minIndex = (Integer)event.getOldValue();
                                int maxIndex = (Integer)event.getNewValue();
                                try {
                                    Element el1 = ProjectNavigatorManager.this.getChildAt(maxIndex, node.getChildren());
                                    Element el2 = ProjectNavigatorManager.this.getChildAt(minIndex, node.getChildren());
                                    node.remove(el1);
                                    node.remove(el2);
                                    node.add(el2, true);
                                    node.add(el1, true);
                                    UpdateMessage message2 = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, node);
                                    node.notifyObservers(node, message2);
                                }
                                catch (NoSuchElementException e) {}
                                continue;
                            }
                            if (!(projectObject instanceof ProjectPreferences) || !"template".equals(event.getPropertyName()) || (studioNode = ProjectNavigatorManager.this.findNode((ProjectObject)(project = projectObject.getProject()))) == null) continue;
                            studioNode.invalidateIcon();
                            continue;
                        }
                        if (event.getType() == ProjectEvent.Type.POST_ADD) {
                            ProjectNavigatorManager.this.addNode(projectObject);
                            continue;
                        }
                        if (event.getType() == ProjectEvent.Type.POST_REMOVE) {
                            ProjectNavigatorManager.this.removeNode(projectObject);
                            continue;
                        }
                        if (event.getType() != ProjectEvent.Type.REPLACE || (node = ProjectNavigatorManager.this.findNode(projectObject)) == null) continue;
                        node.replaceObject((Object)event.getReplacement());
                    }
                }
            };
        }
        return this.projectListener;
    }

    private Element getChildAt(int maxIndex, Iterator<Element> children) {
        Element el = null;
        for (int index = 0; index <= maxIndex; ++index) {
            el = children.next();
        }
        return el;
    }

    private void fixOpenedNodes(ProjectEvent event, ProjectObject projectObject) {
        URL url = Platform.getAdapterService().adaptTo(projectObject, URL.class);
        Iterator openNodes = NodeFactory.getOpenNodes();
        while (openNodes.hasNext()) {
            Node openNode = (Node)openNodes.next();
            if (!(openNode instanceof ProjectObjectNode) || openNode.getURL() == null || !openNode.getURL().equals(url)) continue;
            ((ProjectObjectNode)openNode).replaceObject(event.getReplacement());
            break;
        }
    }
}

