/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.navigator;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.fusion.core.BaseNavigatorManager;
import oracle.bpm.fusion.core.model.AbstractContainerNode;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.core.model.StudioNodeFactory;
import oracle.bpm.fusion.core.model.TreeNodeAdapter;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryAdapter;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

public abstract class AbstractRepositoryNavigatorManager
extends BaseNavigatorManager {
    private ProjectFilter filter;
    private ProjectRepository projectRepository;
    private RepositoryListener repositoryListener;

    protected AbstractRepositoryNavigatorManager(ProjectRepository projectRepository) {
        this.setProjectRepository(projectRepository);
    }

    public ProjectRepository getProjectRepository() {
        return this.projectRepository;
    }

    public void changeProjectRepository(ProjectRepository newRepository) {
        if (this.getProjectRepository() != null) {
            this.getProjectRepository().removeRepositoryListener(this.getRepositoryListener());
        }
        if (newRepository != null) {
            newRepository.addRepositoryListener(this.getRepositoryListener());
        }
        this.setProjectRepository(newRepository);
        this.reloadTree();
    }

    protected StudioNode<ProjectObject> findNode(ProjectObject projectObject) {
        ProjectObject object;
        UiUtilities.assertUiThread();
        List projectObjectPath = ProjectNavigatorTree.calculatePath((ProjectObject)projectObject);
        StudioNode current = this.getRootNode();
        Iterator i$ = projectObjectPath.iterator();
        while (i$.hasNext() && (current = AbstractContainerNode.findChildByData((StudioNode)current, (Object)(object = (ProjectObject)i$.next()))) != null) {
        }
        return current;
    }

    protected ProjectFilter getProjectFilter() {
        if (this.filter == null) {
            this.filter = ProjectFilters.DEFAULT_NAVIGATOR;
        }
        return this.filter;
    }

    void addNode(ProjectObject projectObject) {
        ProjectObjectContainer parentObject;
        StudioNode<ProjectObject> parentNode;
        UiUtilities.assertUiThread();
        if (projectObject != null && (parentNode = this.findNode((ProjectObject)(parentObject = this.getProjectFilter().getParent(projectObject)))) != null && parentNode.isLoaded()) {
            if (TreeNodeAdapter.isExternalNode(projectObject.getClass())) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)Platform.getAdapterService().adaptTo(projectObject, URL.class));
                    node.ensureOpen();
                    parentNode.add((Element)node, true);
                    parentNode.postChildModified();
                }
                catch (IllegalAccessException e) {
                    Log.logSevere(e);
                }
                catch (InstantiationException e) {
                    Log.logSevere(e);
                }
            } else {
                TreeNode nodeAdded = ProjectNavigatorTree.getMainTree().findNode(projectObject);
                if (nodeAdded != null) {
                    StudioNode newNode = StudioNodeFactory.getInstance().createNode(nodeAdded);
                    parentNode.add((Element)newNode, true);
                    assert (parentNode.containsChild((Element)newNode));
                }
            }
        }
    }

    void removeNode(ProjectObject projectObject) {
        Element childNode;
        UiUtilities.assertUiThread();
        ProjectObjectContainer parentObject = this.getProjectFilter().getParent(projectObject);
        StudioNode<ProjectObject> parentNode = this.findNode((ProjectObject)parentObject);
        if (parentNode != null && (childNode = AbstractContainerNode.findChildElementByData(parentNode, (Object)projectObject)) != null) {
            parentNode.remove(childNode, true);
            if (childNode instanceof Node) {
                NodeFactory.uncache((URL)((Node)childNode).getURL());
            }
        }
    }

    private RepositoryListener getRepositoryListener() {
        if (this.repositoryListener == null) {
            this.repositoryListener = new RepositoryAdapter(){

                public void projectOpened(final Project project) {
                    if (!UiUtilities.isEventDispatchThread()) {
                        UiUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.projectOpened(project);
                            }
                        });
                        return;
                    }
                    AbstractRepositoryNavigatorManager.this.addNode((ProjectObject)project);
                }

                public void projectDeleted(final Project project) {
                    if (!UiUtilities.isEventDispatchThread()) {
                        UiUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.projectDeleted(project);
                            }
                        });
                        return;
                    }
                    AbstractRepositoryNavigatorManager.this.removeNode((ProjectObject)project);
                }
            };
        }
        return this.repositoryListener;
    }

    private void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }
}

