/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.awt.Component;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class UnlockMdsProjectAction
extends BaseAction {
    private PublicShareProject publicShareProject;

    public UnlockMdsProjectAction(PublicShareProject publicShareProject) {
        super(FusionStudioMsg.UNLOCK_PROJECT);
        this.requires(MdProject.class);
        this.publicShareProject = publicShareProject;
    }

    public void run() {
        this.unLockMdsProject();
    }

    private void unLockMdsProject() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            int answer = MessageDialog.showQuestion((Msg)FusionStudioMsg.UNLOCK_PROJECT, (Msg)FusionStudioMsg.ASK_CONFIRMATION_FOR_RELEASING_LOCK, (int)6);
            if (answer == 2) {
                FuegoWorker.post((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.UNLOCKING_BPM_MDS_PROJECT.toString());
                        progressMonitor.setCancellable(false);
                        progressMonitor.start();
                        try {
                            oracle.bpm.pml.service.StudioMetadataService studioMetadataService = StudioMetadataService.getInstance().getService();
                            studioMetadataService.releaseLock(UnlockMdsProjectAction.this.publicShareProject);
                            UnlockMdsProjectAction.this.publicShareProject = (PublicShareProject)studioMetadataService.loadProject(PublicShareProject.class, ((ProjectFolder)UnlockMdsProjectAction.this.publicShareProject.getFolder().get()).getLocation()).get();
                            MdsProjectNavigatorManager.getInstance().refresh();
                        }
                        catch (MetadataException e) {
                            MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_UNLOCKING_MDS_PROJECT(e.getMessage()));
                            ProgramException.wrap("Problems while unlocking Mds Project.", e).printStackTrace();
                        }
                        finally {
                            progressMonitor.finish();
                        }
                    }
                });
            }
        }
    }
}

