/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.pml.service.impl.StudioMetadataServiceImpl;
import oracle.bpm.resources.Msg;
import oracle.mds.core.MDSInstance;

public class StudioMetadataService {
    private Collection<ConfigurationListener> configurationListeners = new ArrayList<ConfigurationListener>();
    private MDSInstance mdsInstance;
    private oracle.bpm.pml.service.StudioMetadataService service;
    private Status status = Status.DISCONNECTED;
    private Collection<StatusListener> statusListeners = new ArrayList<StatusListener>();
    private static StudioMetadataService instance;
    private static final String MDS_HOME;

    private StudioMetadataService() {
    }

    public static synchronized StudioMetadataService getInstance() {
        if (instance == null) {
            instance = new StudioMetadataService();
        }
        return instance;
    }

    public oracle.bpm.pml.service.StudioMetadataService getService() {
        return this.service;
    }

    public MdTree getAllTemplates() throws MetadataException {
        return this.service.getTemplates(null, null);
    }

    public MdTree getAllPublicShares() throws MetadataException {
        return this.service.getPublicShares(null, null);
    }

    public void changeMdsInstance(MDSInstance mdsInstance) throws MetadataException {
        this.mdsInstance = mdsInstance;
        if (mdsInstance != null) {
            this.service = new StudioMetadataServiceImpl(mdsInstance);
        }
        this.status = null;
        this.checkConnection();
        this.fireConfigurationChanged();
    }

    public void addStatusListener(StatusListener statusListener) {
        this.statusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.statusListeners.remove(statusListener);
    }

    public String getCurrentMdsConnectionName() {
        if (this.mdsInstance != null) {
            return this.mdsInstance.getName();
        }
        return "";
    }

    public boolean isStatusDisconnected() {
        this.checkConnection();
        return this.status == Status.DISCONNECTED;
    }

    public boolean isStatusConnecting() {
        this.checkConnection();
        return this.status == Status.CONNECTING;
    }

    public boolean isStatusConnected() {
        this.checkConnection();
        return this.status == Status.CONNECTED;
    }

    public void startStatusConnecting() {
        this.changeStatus(Status.CONNECTING);
    }

    public Status getStatus() {
        return this.status;
    }

    public void disconnect() {
        try {
            this.changeMdsInstance(null);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        this.configurationListeners.add(configurationListener);
    }

    public void removeConfigurationListener(ConfigurationListener configurationListener) {
        this.configurationListeners.remove(configurationListener);
    }

    private void fireStatusChanged(Status newStatus, Status oldStatus) {
        for (StatusListener statusListener : this.statusListeners) {
            statusListener.statusChanged(newStatus, oldStatus);
        }
    }

    private void checkConnection() {
        if (this.status != Status.CONNECTING) {
            if (this.getMdsInstance() == null) {
                this.changeStatus(Status.DISCONNECTED);
            } else {
                this.changeStatus(Status.CONNECTED);
            }
        }
    }

    private void changeStatus(Status newStatus) {
        if (this.status != newStatus) {
            Status oldStatus = this.status;
            this.status = newStatus;
            this.fireStatusChanged(this.status, oldStatus);
        }
    }

    private MDSInstance getMdsInstance() {
        return this.mdsInstance;
    }

    private File findOrCreateMdsDirectory() {
        File mdsDirectory = new File(MDS_HOME);
        if (!mdsDirectory.exists()) {
            mdsDirectory.mkdirs();
        }
        return mdsDirectory;
    }

    private void fireConfigurationChanged() {
        for (ConfigurationListener configurationListener : this.configurationListeners) {
            configurationListener.configurationChanged(this.service);
        }
    }

    static {
        MDS_HOME = System.getProperty("user.home") + File.separator + "mdsrepo";
    }

    public static interface StatusListener {
        public void statusChanged(Status var1, Status var2);
    }

    public static interface ConfigurationListener {
        public void configurationChanged(oracle.bpm.pml.service.StudioMetadataService var1);
    }

    public static enum Status {
        CONNECTED(FusionStudioMsg.CONNECTED),
        DISCONNECTED(FusionStudioMsg.DISCONNECTED),
        CONNECTING(FusionStudioMsg.CONNECTING);

        private Msg msg;

        public Msg getMsg() {
            return this.msg;
        }

        private Status(Msg msg) {
            this.msg = msg;
        }
    }
}

