/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import oracle.bpm.fusion.studio.mds.ConfigureMdsConnectionAction;
import oracle.bpm.fusion.studio.mds.PublishMdsProjectDialog;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public class PublishProjectToMdsAction
extends BaseAction {
    private Project project;

    public PublishProjectToMdsAction() {
        super(FusionStudioMsg.PUBLISH_PROJECT_TO_MDS);
        this.requires(Project.class);
    }

    public PublishProjectToMdsAction(Project project) {
        this();
        this.project = project;
    }

    public void run() {
        this.publishProject();
    }

    public void runWithSelection(Selection selection) {
        this.project = (Project)selection.as(Project.class);
        this.publishProject();
    }

    private void publishProject() {
        if (!StudioMetadataService.getInstance().isStatusConnected() && !this.configureMdsconnection()) {
            return;
        }
        this.performPublish();
    }

    private void performPublish() {
        PublishMdsProjectDialog dialog = new PublishMdsProjectDialog(Ui.getRoot(), this.project);
        dialog.setVisible(true);
    }

    private boolean configureMdsconnection() {
        return new ConfigureMdsConnectionAction().configureMdsConnection();
    }
}

