/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.awt.Component;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.EmptyNameValidator;
import oracle.bpm.designer.validator.Validator;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.studio.mds.CreateMdsFolderAction;
import oracle.bpm.fusion.studio.mds.DeleteMdsFolderAction;
import oracle.bpm.fusion.studio.mds.MdsArtifactType;
import oracle.bpm.fusion.studio.mds.MdsFolderNode;
import oracle.bpm.fusion.studio.mds.MdsNodeFactory;
import oracle.bpm.fusion.studio.mds.MdsNodeNavigator;
import oracle.bpm.fusion.studio.mds.MdsProjectFolderTreeNode;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.text.FilteredTextField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TextFilter;
import oracle.bpm.ui.text.filter.ValidFileFilter;
import oracle.bpm.ui.tree.TreeBasePanel;
import oracle.bpm.ui.tree.TreeNode;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import org.jetbrains.annotations.NotNull;

public class PublishMdsProjectDialog
extends OkCancelDialog {
    private TextArea descriptionText;
    private MdsFolderTreePanel mdsFolderTreePanel;
    private CheckBox overrideCheckBox;
    private Project project;
    private TextField projectNameTextField;

    public PublishMdsProjectDialog(UiWindow parent, Project project) {
        super(parent, FusionStudioMsg.PUBLISH_PROJECT_TO_MDS, true);
        this.project = project;
        this.buildUi();
    }

    public void ok() {
        FuegoWorker.post((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)PublishMdsProjectDialog.this.getContentPane().asSwing(), FusionStudioMsg.PUBLISHING_PROJECT.toString());
                progressMonitor.setCancellable(false);
                progressMonitor.start();
                if (PublishMdsProjectDialog.this.isValid()) {
                    try {
                        ProjectFolder folder = PublishMdsProjectDialog.this.getProjectFolder();
                        if (PublishMdsProjectDialog.this.project.isTemplate()) {
                            PublishMdsProjectDialog.this.publishTemplateProject(folder);
                        } else {
                            PublishMdsProjectDialog.this.publishPublicShareProject(folder);
                        }
                    }
                    catch (MetadataException e) {
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_PUBLISHING_TO_MDS(e.getMessage()));
                    }
                    finally {
                        PublishMdsProjectDialog.this.setVisible(false);
                        progressMonitor.finish();
                    }
                }
            }
        });
    }

    MdsNodeNavigator getMdsNodeNavigator() {
        return MdsProjectNavigatorManager.getInstance().getMdsNodeNavigator();
    }

    private void buildUi() {
        Panel mainPanel = new Panel(this.getContentPane());
        StandardForm layout = FormsFactory.createStandardForm((UiContainer)mainPanel);
        Label projectNameLabel = Label.create((UiContainer)mainPanel, (Msg)DesignerMsg.PROJECT_NAME);
        this.projectNameTextField = new FilteredTextField((UiContainer)mainPanel, (TextFilter)new ValidFileFilter(FileSystemTokens.MAX_FILE_NAME_LENGTH, false){

            public boolean accepts(String str, int offs) {
                return (offs != 0 || str.length() <= 0 || !Character.isDigit(str.charAt(offs))) && super.accepts(str, offs);
            }
        }, this.project.getName(), 20);
        Label descriptionLabel = Label.create((UiContainer)mainPanel, (Msg)ProjectMsg.DESCRIPTION);
        this.descriptionText = new TextArea((UiContainer)mainPanel);
        this.overrideCheckBox = CheckBox.create((UiContainer)mainPanel, (Msg)FusionStudioMsg.OVERRIDE);
        try {
            MdsFolderNode folderNode = this.getRootObject(this.project);
            this.mdsFolderTreePanel = new MdsFolderTreePanel((UiContainer)mainPanel, folderNode, this.getMdsNodeNavigator());
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        layout.add((UiComponent)projectNameLabel);
        layout.add((UiComponent)this.projectNameTextField);
        layout.add((UiComponent)descriptionLabel);
        layout.add((UiComponent)this.descriptionText);
        layout.add((UiComponent)this.overrideCheckBox);
        layout.add((UiComponent)this.mdsFolderTreePanel);
        this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void publishPublicShareProject(ProjectFolder folder) throws MetadataException {
        oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
        LocalRef<PublicShareProject> mdsPublicShareProject = this.getProject(folder.getLocation() + "/" + this.getProjectName());
        if (mdsPublicShareProject != null) {
            if (((PublicShareProject)mdsPublicShareProject.get()).isLocked() && !"BPM Studio".equals(((PublicShareProject)mdsPublicShareProject.get()).getUserLock())) {
                MessageDialog.showError((Msg)FusionStudioMsg.MDS_PROJECT_LOCKED);
            } else {
                PublicShareProject publicShare = new PublicShareProject(this.getProjectName(), this.getDescription(), this.project);
                publicShare.setAllowSharing(true);
                publicShare = metadataService.savePublicShare(folder, publicShare, this.overrideCheckBox.isSelected(), true);
                MdsProjectNavigatorManager.getInstance().addProjectArtifact(MdsArtifactType.PUBLIC_SHARE, (ProjectArtifact)publicShare);
            }
        } else {
            PublicShareProject publicShare = new PublicShareProject(this.getProjectName(), this.getDescription(), this.project);
            publicShare.setAllowSharing(true);
            publicShare = metadataService.savePublicShare(folder, publicShare, this.overrideCheckBox.isSelected(), false);
            MdsProjectNavigatorManager.getInstance().addProjectArtifact(MdsArtifactType.PUBLIC_SHARE, (ProjectArtifact)publicShare);
        }
    }

    private LocalRef<PublicShareProject> getProject(String fullProjectPath) throws MetadataException {
        LocalRef ret = null;
        try {
            ret = StudioMetadataService.getInstance().getService().loadProject(PublicShareProject.class, fullProjectPath);
        }
        catch (ProjectNotFoundException projectNotFoundException) {
            // empty catch block
        }
        return ret;
    }

    private void publishTemplateProject(ProjectFolder folder) throws MetadataException {
        oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
        TemplateProject mdsProject = new TemplateProject(this.getProjectName(), this.getDescription(), this.project);
        metadataService.saveTemplateProject(folder, mdsProject, this.overrideCheckBox.isSelected(), true);
        MdsProjectNavigatorManager.getInstance().addProjectArtifact(MdsArtifactType.TEMPLATE, (ProjectArtifact)mdsProject);
    }

    private MdsFolderNode getRootObject(Project project) throws MetadataException {
        return project.isTemplate() ? this.getMdsNodeNavigator().getTemplatesFolderNode() : this.getMdsNodeNavigator().getPublicSharesFolderNode();
    }

    private ProjectFolder getProjectFolder() {
        if (this.mdsFolderTreePanel.getSelectedNode().length == 1) {
            MdsFolderNode selectedMdsFolderNode = (MdsFolderNode)this.mdsFolderTreePanel.getSelectedNode()[0].getUserObject();
            return selectedMdsFolderNode.isDefault() ? ProjectFolder.create((String)"/") : (ProjectFolder)selectedMdsFolderNode.getObject();
        }
        return ProjectFolder.create((String)"/");
    }

    private String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private String getDescription() {
        return this.descriptionText.getText();
    }

    private boolean isValid() {
        Msg messageError = this.getValidator().validate((Object)this.projectNameTextField.getText());
        boolean ret = true;
        if (messageError != null) {
            MessageDialog.showError((Msg)messageError);
            ret = false;
        }
        return ret;
    }

    private CompositeValidator<String> getValidator() {
        CompositeValidator validator = new CompositeValidator();
        validator.addValidator((Validator)new EmptyNameValidator());
        return validator;
    }

    private class MdsFolderTreePanel
    extends TreeBasePanel {
        public MdsFolderTreePanel(UiContainer parent, MdsFolderNode rootObject, MdsNodeNavigator mdsNodeNavigator) {
            super(parent, FusionStudioMsg.MDS_PROJECT_LOCATION);
            this.init(rootObject, mdsNodeNavigator);
        }

        protected void addAction(@NotNull TreeNode selectedNode) {
            MdsFolderNode parentMdsFolderNode = (MdsFolderNode)selectedNode.getUserObject();
            CreateMdsFolderAction createMdsFolderAction = new CreateMdsFolderAction(parentMdsFolderNode);
            createMdsFolderAction.run();
            ProjectFolder newProjectFolder = createMdsFolderAction.getProjectFolderCreated();
            if (newProjectFolder != null) {
                StudioNode<ProjectArtifact> newMdsFolderNode = MdsNodeFactory.getInstance().createNode((ProjectArtifact)newProjectFolder);
                TreeNode newTreeNode = selectedNode.addDynamic(newMdsFolderNode);
                MdsFolderNode mdsFolderNode = (MdsFolderNode)newTreeNode.getUserObject();
                mdsFolderNode.setParent((MdsFolderNode)selectedNode.getUserObject());
                mdsFolderNode.setDefault(false);
                newTreeNode.select();
            }
        }

        protected void deleteAction(@NotNull TreeNode selectedNode) {
            MdsFolderNode mdsFolderNode = (MdsFolderNode)selectedNode.getUserObject();
            DeleteMdsFolderAction deleteMdsFolderAction = new DeleteMdsFolderAction(mdsFolderNode);
            deleteMdsFolderAction.run();
            if (deleteMdsFolderAction.wasDeleted()) {
                super.deleteAction(selectedNode);
            }
        }

        private void init(MdsFolderNode rootObject, MdsNodeNavigator mdsNodeNavigator) {
            MdsProjectFolderTreeNode node = (MdsProjectFolderTreeNode)TreeNode.createDynamic((Object)rootObject);
            node.setMdsNodeNavigator(mdsNodeNavigator);
            this.setRoot(node);
        }
    }
}

