/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.fusion.studio.mds.CheckoutMdsProjectAction;
import oracle.bpm.fusion.studio.mds.DeleteMdsProjectAction;
import oracle.bpm.fusion.studio.mds.ExportMdsProjectAction;
import oracle.bpm.fusion.studio.mds.LockMdsProjectAction;
import oracle.bpm.fusion.studio.mds.MdsArtifactType;
import oracle.bpm.fusion.studio.mds.MdsProjectNode;
import oracle.bpm.fusion.studio.mds.UnlockMdsProjectAction;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=MdsProjectNode.class)
public class MdsProjectNodeActionGroupFactory
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        MdsProjectNode mdsProjectNode = context.as(MdsProjectNode.class);
        MdProject mdProject = (MdProject)mdsProjectNode.getObject();
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add((BaseAction)new CheckoutMdsProjectAction((MdProject<? extends ProjectArtifact>)mdProject));
        if (MdsArtifactType.PUBLIC_SHARE == mdsProjectNode.getType()) {
            PublicShareProject publicShareProject = (PublicShareProject)mdsProjectNode.getObject();
            if (!publicShareProject.isLocked()) {
                actionGroup.add((BaseAction)new LockMdsProjectAction(publicShareProject));
            } else {
                actionGroup.add((BaseAction)new UnlockMdsProjectAction(publicShareProject));
            }
        }
        actionGroup.add((BaseAction)new ExportMdsProjectAction((MdProject<? extends ProjectArtifact>)mdProject));
        actionGroup.add((BaseAction)new DeleteMdsProjectAction(mdsProjectNode));
        return actionGroup;
    }
}

