/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bpm.fusion.core.BaseNavigatorManager;
import oracle.bpm.fusion.core.model.DefaultRootChildrenResolver;
import oracle.bpm.fusion.core.model.DefaultRootNode;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.studio.mds.FolderObject;
import oracle.bpm.fusion.studio.mds.IMdsNode;
import oracle.bpm.fusion.studio.mds.MdsArtifactType;
import oracle.bpm.fusion.studio.mds.MdsNodeFactory;
import oracle.bpm.fusion.studio.mds.MdsNodeNavigator;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorWindow;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;

public class MdsProjectNavigatorManager
extends BaseNavigatorManager
implements DefaultRootChildrenResolver<StudioNode, FolderObject> {
    private MdsNodeNavigator mdsNodeNavigator;
    private static MdsProjectNavigatorManager instance;
    public static final String NAVIGATOR_WINDOW_ID = "MdsProjectNavigator";
    private static final String NAVIGATOR_KEY = "MDS";

    private MdsProjectNavigatorManager() {
        Menubar menuMgr = Ide.getMenubar();
        IdeAction showAction = this.getShowAction();
        JMenuItem navigatorMenuItem = menuMgr.createMenuItem((ToggleAction)showAction);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        menuMgr.add((Component)navigatorMenuItem, viewMenu, MenuConstants.SECTION_VIEW_ADDINS);
        StudioMetadataService.getInstance().addStatusListener(new StudioMetadataService.StatusListener(){

            @Override
            public void statusChanged(StudioMetadataService.Status newStatus, StudioMetadataService.Status oldStatus) {
                MdsProjectNavigatorManager.this.refresh();
            }
        });
    }

    public static synchronized MdsProjectNavigatorManager getInstance() {
        if (instance == null) {
            instance = new MdsProjectNavigatorManager();
        }
        return instance;
    }

    public Iterable<StudioNode> getChildren() {
        return this.getMdsNodeNavigator().getChildren(this.getRootNode());
    }

    public void refreshFolder(FolderObject folderObject) {
        Iterator childrenIterator = this.getRootNode().getChildren();
        while (childrenIterator.hasNext()) {
            StudioNode studioNode = (StudioNode)childrenIterator.next();
            if (studioNode.getObject() != folderObject) continue;
            TreeExplorer treeExplorer = this.getNavigatorWindow().getTreeExplorer();
            TNode node = treeExplorer.findTNode((Element)studioNode, treeExplorer.getRoot());
            treeExplorer.refresh(node);
        }
    }

    public void addProjectArtifact(MdsArtifactType type, ProjectArtifact projectArtifact) {
        this.mdsNodeNavigator.addNode(type, projectArtifact, true);
    }

    public void removeProjectArtifact(IMdsNode mdsFolderNode) {
        this.mdsNodeNavigator.removeNode(mdsFolderNode, true);
    }

    public void refresh() {
        this.mdsNodeNavigator = null;
        super.refresh();
        this.getNavigatorWindow().updateVisibleActions();
    }

    protected StudioNode<ProjectObject> createRootNode() {
        return new DefaultRootNode(null, ProjectModelMsg.PROJECT, (DefaultRootChildrenResolver)this);
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)Ide.findOrCreateCmdID((String)"fusion.studio.showMdsProjectNavigator"), null, (String)FusionStudioMsg.MDS_PROJECT_NAVIGATOR.toString(), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, null, (Icon)Image.create((Msg)FusionStudioMsg.MDS_PROJECT_NAVIGATOR).asSwingIcon(), null, (boolean)true);
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)this.getRootNode(), false, 1);
    }

    protected NavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new MdsProjectNavigatorWindow(context, viewId.getId());
    }

    protected String getDefaultName() {
        return NAVIGATOR_WINDOW_ID;
    }

    protected String getViewCategory() {
        return "BpmStudioViewMDS";
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam param = super.createNavigatorDockingParam();
        DockStation ds = DockStation.getDockStation();
        NavigatorManager navigator = NavigatorManager.getApplicationNavigatorManager();
        ViewId viewId = navigator.getDefaultViewId();
        Dockable d = ds.findDockable(viewId);
        param.setPosition(d, 4, 0);
        return param;
    }

    MdsNodeNavigator getMdsNodeNavigator() {
        if (this.mdsNodeNavigator == null) {
            this.mdsNodeNavigator = new MdsNodeNavigator(MdsNodeFactory.getInstance());
        }
        return this.mdsNodeNavigator;
    }
}

