/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.fusion.core.model.DefaultRootNode;
import oracle.bpm.fusion.core.model.NodeFactory;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.core.model.VirtualNode;
import oracle.bpm.fusion.studio.mds.IMdsNode;
import oracle.bpm.fusion.studio.mds.MdsArtifactType;
import oracle.bpm.fusion.studio.mds.MdsFolderNode;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.MdTreeNode;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.ide.model.Element;
import org.jetbrains.annotations.NotNull;

public class MdsNodeNavigator {
    private NodeFactory<ProjectArtifact, ProjectArtifact> nodeFactory;
    private MdsFolderNode publicSharesNode;
    private MdsFolderNode templatesNode;

    public MdsNodeNavigator(NodeFactory<ProjectArtifact, ProjectArtifact> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    Iterable<StudioNode> getChildren(StudioNode studioNode) {
        ArrayList<StudioNode> childrenNodes = new ArrayList<StudioNode>();
        if (studioNode instanceof DefaultRootNode) {
            StudioMetadataService metadataService = StudioMetadataService.getInstance();
            if (metadataService.isStatusConnecting()) {
                childrenNodes.add(this.constructConnectingNode());
                return childrenNodes;
            }
            if (metadataService.isStatusConnected()) {
                childrenNodes.add(this.getTemplatesFolderNode());
                childrenNodes.add(this.getPublicSharesFolderNode());
                return childrenNodes;
            }
        }
        if (studioNode instanceof IMdsNode) {
            ArrayList<StudioNode> children = new ArrayList<StudioNode>();
            Iterator elementIt = studioNode.getChildren();
            while (elementIt.hasNext()) {
                children.add((StudioNode)elementIt.next());
            }
            return children;
        }
        return CollectionUtils.emptyIterable();
    }

    StudioNode getParent(StudioNode studioNode) {
        if (studioNode instanceof IMdsNode) {
            IMdsNode mdsNode = (IMdsNode)studioNode;
            return mdsNode.getParent();
        }
        return null;
    }

    StudioNode findNode(@NotNull StudioNode rootNode, ProjectArtifact projectArtifact) {
        if (this.haveProjectArtifactAsObject(projectArtifact, rootNode)) {
            return rootNode;
        }
        Iterator elementIt = rootNode.getChildren();
        while (elementIt.hasNext()) {
            StudioNode node;
            Element element = (Element)elementIt.next();
            if (!(element instanceof StudioNode) || (node = this.findNode((StudioNode)element, projectArtifact)) == null) continue;
            return node;
        }
        return null;
    }

    MdsFolderNode getTemplatesFolderNode() {
        if (this.templatesNode == null) {
            ProjectFolder templatesFolder = ProjectFolder.create((String)FusionStudioMsg.MDS_TEMPLATES.toString());
            this.templatesNode = new MdsFolderNode(templatesFolder, FusionStudioMsg.MDS_TEMPLATES);
            this.templatesNode.setDefault(true);
            this.initTemplatesChildren(this.templatesNode);
        }
        return this.templatesNode;
    }

    MdsFolderNode getPublicSharesFolderNode() {
        if (this.publicSharesNode == null) {
            ProjectFolder publicSharesFolder = ProjectFolder.create((String)FusionStudioMsg.MDS_PUBLIC.toString());
            this.publicSharesNode = new MdsFolderNode(publicSharesFolder, FusionStudioMsg.MDS_PUBLIC);
            this.publicSharesNode.setDefault(true);
            this.initPublicSharesChildren(this.publicSharesNode);
        }
        return this.publicSharesNode;
    }

    void addNode(MdsArtifactType type, ProjectArtifact projectArtifact, boolean notify) {
        if (MdsArtifactType.TEMPLATE == type) {
            this.createRootTypeFolderTree(this.getTemplatesFolderNode(), projectArtifact, notify);
        }
        if (MdsArtifactType.PUBLIC_SHARE == type) {
            this.createRootTypeFolderTree(this.getPublicSharesFolderNode(), projectArtifact, notify);
        }
    }

    void removeNode(IMdsNode mdsNode, boolean notify) {
        StudioNode parentNode = this.getParent(mdsNode);
        if (parentNode != null) {
            parentNode.remove((Element)mdsNode, notify);
            parentNode.markDirty(false);
        }
    }

    private StudioNode constructConnectingNode() {
        Msg msg = StudioMetadataService.getInstance().getStatus().getMsg();
        return new VirtualNode(null, msg);
    }

    private void initTemplatesChildren(@NotNull MdsFolderNode mdsFolderNode) {
        try {
            MdTree mdTree = StudioMetadataService.getInstance().getAllTemplates();
            this.populateTree(mdsFolderNode, mdTree);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    private void initPublicSharesChildren(MdsFolderNode mdsFolderNode) {
        try {
            MdTree mdTree = StudioMetadataService.getInstance().getAllPublicShares();
            this.populateTree(mdsFolderNode, mdTree);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    private void populateTree(@NotNull MdsFolderNode mdsFolderNode, @NotNull MdTree mdTree) {
        MdTreeNode rootNode = mdTree.getRootNode();
        List treeNodeList = rootNode.getChildren();
        this.populateNode(mdsFolderNode, treeNodeList);
    }

    private void populateNode(@NotNull MdsFolderNode mdsFolderNode, @NotNull List<MdTreeNode<ProjectArtifact>> children) {
        if (!children.isEmpty()) {
            for (MdTreeNode<ProjectArtifact> node : children) {
                ProjectArtifact projectArtifact = node.getObject();
                IMdsNode rootTypeFolderTree = this.createRootTypeFolderTree(mdsFolderNode, projectArtifact, false);
                if (projectArtifact.isMdProject()) continue;
                this.populateNode((MdsFolderNode)rootTypeFolderTree, node.getChildren());
            }
        }
    }

    private IMdsNode createRootTypeFolderTree(@NotNull StudioNode rootTypeFolderNode, @NotNull ProjectArtifact projectArtifact, boolean notify) {
        ProjectFolder parentFolder;
        IMdsNode projectArtifactStudioNode = this.findOrCreateIMdsNode(rootTypeFolderNode, projectArtifact);
        ProjectFolder projectFolder = parentFolder = projectArtifact.getParentFolder() != null ? (ProjectFolder)projectArtifact.getParentFolder().get() : null;
        if (parentFolder == null || Str.isEmpty(parentFolder.getName())) {
            projectArtifactStudioNode.setParent((MdsFolderNode)rootTypeFolderNode);
            rootTypeFolderNode.add((Element)projectArtifactStudioNode, notify);
            rootTypeFolderNode.markDirty(false);
        } else {
            StudioNode parentFolderNode = this.findNode(rootTypeFolderNode, (ProjectArtifact)parentFolder);
            if (parentFolderNode == null) {
                this.createRootTypeFolderTree(rootTypeFolderNode, (ProjectArtifact)parentFolder, notify);
                parentFolderNode = this.findNode(rootTypeFolderNode, (ProjectArtifact)parentFolder);
            }
            projectArtifactStudioNode.setParent((MdsFolderNode)parentFolderNode);
            parentFolderNode.add((Element)projectArtifactStudioNode, notify);
            parentFolderNode.markDirty(false);
        }
        return projectArtifactStudioNode;
    }

    private IMdsNode findOrCreateIMdsNode(@NotNull StudioNode rootNode, ProjectArtifact projectArtifact) {
        IMdsNode projectArtifactNode = (IMdsNode)this.findNode(rootNode, projectArtifact);
        return projectArtifactNode == null ? (IMdsNode)this.nodeFactory.createNode((Object)projectArtifact) : projectArtifactNode;
    }

    private boolean haveProjectArtifactAsObject(@NotNull ProjectArtifact projectArtifact, @NotNull StudioNode studioNode) {
        return projectArtifact.equals(studioNode.getObject());
    }
}

