/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.awt.Component;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class LockMdsProjectAction
extends BaseAction {
    private PublicShareProject publicShareProject;

    public LockMdsProjectAction(PublicShareProject publicShareProject) {
        super(FusionStudioMsg.LOCK_PROJECT);
        this.requires(MdProject.class);
        this.publicShareProject = publicShareProject;
    }

    public void run() {
        this.lockMdsProject();
    }

    private void lockMdsProject() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            FuegoWorker.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.LOCKING_BPM_MDS_PROJECT.toString());
                    progressMonitor.setCancellable(false);
                    progressMonitor.start();
                    try {
                        oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
                        metadataService.acquireLock(LockMdsProjectAction.this.publicShareProject, "BPM Studio");
                        LockMdsProjectAction.this.publicShareProject = (PublicShareProject)metadataService.loadProject(PublicShareProject.class, ((ProjectFolder)LockMdsProjectAction.this.publicShareProject.getFolder().get()).getLocation()).get();
                        MdsProjectNavigatorManager.getInstance().refresh();
                    }
                    catch (MetadataException e) {
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_LOCKING_MDS_PROJECT(e.getMessage()));
                        ProgramException.wrap("Problems while locking Mds Project.", e).printStackTrace();
                    }
                    finally {
                        progressMonitor.finish();
                    }
                }
            });
        }
    }
}

