/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.ui.wizards.ExportFuegoProjectWizard;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;

public class ExportMdsProjectAction
extends BaseAction {
    private MdProject<? extends ProjectArtifact> mdsProject;

    public ExportMdsProjectAction() {
        super(FusionStudioMsg.EXPORT_MDS_PROJECT);
        this.requires(MdProject.class);
    }

    public ExportMdsProjectAction(MdProject<? extends ProjectArtifact> mdsProject) {
        this();
        this.mdsProject = mdsProject;
    }

    public void run() {
        this.exportProject();
    }

    private void exportProject() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            ExportFuegoProjectWizard exportWizard = new ExportFuegoProjectWizard(this.getProject(), true, FusionStudioMsg.EXPORT_MDS_PROJECT);
            exportWizard.run();
        }
    }

    private Project getProject() {
        try {
            return (Project)this.mdsProject.getProject().get();
        }
        catch (MetadataException e) {
            throw ProgramException.wrap("Problems while getting the project from MDS.", e);
        }
    }
}

