/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.awt.Component;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.studio.mds.MdsProjectNode;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class DeleteMdsProjectDialog
extends OkCancelDialog {
    private MdsProjectNode mdsProjectNode;

    public DeleteMdsProjectDialog(UiWindow parent, MdsProjectNode mdsProjectNode) {
        super(parent, FusionStudioMsg.DELETE_MDS_PROJECT_TITLE, true);
        this.mdsProjectNode = mdsProjectNode;
        this.buildUi();
    }

    public void ok() {
        FuegoWorker.post((Runnable)new Runnable(){

            @Override
            public void run() {
                IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)DeleteMdsProjectDialog.this.getContentPane().asSwing(), FusionStudioMsg.DELETING_PROJECT.toString());
                progressMonitor.setCancellable(false);
                progressMonitor.start();
                ProjectFolder projectFolder = DeleteMdsProjectDialog.this.getProjectFolder(DeleteMdsProjectDialog.this.mdsProjectNode);
                try {
                    if (TemplateProject.class.equals(DeleteMdsProjectDialog.this.mdsProjectNode.getType().getClassType())) {
                        StudioMetadataService.getInstance().getService().deleteTemplateProject(projectFolder);
                    } else {
                        StudioMetadataService.getInstance().getService().deletePublicShare(projectFolder);
                    }
                    MdsProjectNavigatorManager.getInstance().removeProjectArtifact(DeleteMdsProjectDialog.this.mdsProjectNode);
                }
                catch (MetadataException e) {
                    MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_DELETING_MDS_PROJECT(e.getMessage()));
                    throw ProgramException.wrap("Problems while deleting MDS Project: " + projectFolder, e);
                }
                finally {
                    DeleteMdsProjectDialog.this.setVisible(false);
                    progressMonitor.finish();
                }
            }
        });
    }

    private void buildUi() {
        Msg msg = this.mdsProjectNode.getObject() instanceof PublicShareProject && ((PublicShareProject)this.mdsProjectNode.getObject()).isLocked() ? DesignerMsg.CONFIRM_DELETION_LOCKED((String)this.mdsProjectNode.getShortLabel()) : DesignerMsg.CONFIRM_DELETION((String)this.mdsProjectNode.getShortLabel());
        Panel mainPanel = new Panel(this.getContentPane());
        StandardForm layout = FormsFactory.createStandardForm((UiContainer)mainPanel);
        layout.add((UiComponent)Label.create((UiContainer)mainPanel, (Msg)msg));
        this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private ProjectFolder getProjectFolder(MdsProjectNode mdsProjectNode) {
        return (ProjectFolder)((MdProject)mdsProjectNode.getObject()).getFolder().get();
    }
}

