/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.studio.mds.MdsFolderNode;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;

public class DeleteMdsFolderAction
extends BaseAction {
    private MdsFolderNode mdsFolderNode;
    private boolean wasDeleted = false;

    public DeleteMdsFolderAction(MdsFolderNode mdsFolderNode) {
        super(FusionStudioMsg.DELETE_FOLDER);
        this.requires(MdsFolderNode.class);
        this.mdsFolderNode = mdsFolderNode;
    }

    public void run() {
        this.deleteMdsFolder();
    }

    public boolean wasDeleted() {
        return this.wasDeleted;
    }

    private void deleteMdsFolder() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            int answer = MessageDialog.showQuestion((Msg)FusionStudioMsg.DELETE_FOLDER, (Msg)DesignerMsg.CONFIRM_DELETION((String)this.mdsFolderNode.getShortLabel()), (int)9);
            if (answer == 1) {
                try {
                    StudioMetadataService.getInstance().getService().deleteFolder(this.mdsFolderNode.getType().getClassType(), (ProjectFolder)this.mdsFolderNode.getObject(), true);
                    MdsProjectNavigatorManager.getInstance().removeProjectArtifact(this.mdsFolderNode);
                    this.wasDeleted = true;
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                    MessageDialog.showError((Throwable)e);
                }
            }
        }
    }
}

