/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.EmptyNameValidator;
import oracle.bpm.designer.validator.StringValidator;
import oracle.bpm.designer.validator.Validator;
import oracle.bpm.fusion.studio.mds.MdsFolderNode;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class CreateMdsFolderDialog
extends OkCancelDialog {
    private TextField nameTextField;
    private MdsFolderNode parentFolderNode;
    private ProjectFolder projectFolderCreated;

    public CreateMdsFolderDialog(@NotNull MdsFolderNode parentFolderNode, Msg title) {
        super(Ui.getRoot(), title);
        this.parentFolderNode = parentFolderNode;
        this.buildUi();
    }

    public ProjectFolder getProjectFolderCreated() {
        return this.projectFolderCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ok() {
        String folderName = this.nameTextField.getText();
        Msg validationMessage = this.getValidator().validate((Object)folderName);
        if (validationMessage == null) {
            try {
                this.projectFolderCreated = this.parentFolderNode.isDefault() ? ProjectFolder.create((String)folderName) : ProjectFolder.create((ProjectFolder)((ProjectFolder)this.parentFolderNode.getObject()), (String)folderName);
                StudioMetadataService.getInstance().getService().createFolder(this.parentFolderNode.getType().getClassType(), this.projectFolderCreated);
                MdsProjectNavigatorManager.getInstance().addProjectArtifact(this.parentFolderNode.getType(), (ProjectArtifact)this.projectFolderCreated);
            }
            catch (MetadataException e) {
                MessageDialog.showError((Throwable)e);
                this.projectFolderCreated = null;
            }
            finally {
                this.setVisible(false);
            }
        } else {
            MessageDialog.showError((Msg)validationMessage);
        }
    }

    private void buildUi() {
        Panel mainPanel = new Panel(this.getContentPane(), UIMsg.TO_MSG((String)""));
        StandardForm form = FormsFactory.createStandardForm((UiContainer)mainPanel);
        this.nameTextField = new TextField((UiContainer)mainPanel);
        form.add(DesignerMsg.NAME, (UiComponent)this.nameTextField);
        this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private CompositeValidator<String> getValidator() {
        CompositeValidator validator = new CompositeValidator();
        validator.addValidator((Validator)new EmptyNameValidator());
        validator.addValidator((Validator)new ValidCharactersValidator());
        return validator;
    }

    private class ValidCharactersValidator
    extends StringValidator {
        private ValidCharactersValidator() {
        }

        public Msg validate(String objectToAdd) {
            for (int i = 0; i < objectToAdd.length(); ++i) {
                int c = objectToAdd.codePointAt(i);
                if (this.checkChar(c)) continue;
                return DesignerMsg.OBJECT_NAME_CANNOT_CONTAIN((String)("'" + objectToAdd.charAt(i) + "'"));
            }
            return null;
        }

        private boolean checkChar(int c) {
            return Character.isLetterOrDigit(c) || c == 95;
        }
    }
}

