/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import oracle.bpm.fusion.studio.mds.CreateMdsFolderDialog;
import oracle.bpm.fusion.studio.mds.MdsFolderNode;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public class CreateMdsFolderAction
extends BaseAction {
    private MdsFolderNode parentFolderNode;
    private ProjectFolder projectFolderCreated;

    public CreateMdsFolderAction() {
        super(FusionStudioMsg.CREATE_FOLDER);
        this.requires(MdsFolderNode.class);
    }

    public CreateMdsFolderAction(MdsFolderNode parentFolderNode) {
        this();
        this.parentFolderNode = parentFolderNode;
    }

    public void run() {
        this.createMdsFolder();
    }

    public ProjectFolder getProjectFolderCreated() {
        return this.projectFolderCreated;
    }

    protected void updateEnableStatus(Selection s) {
        this.setEnabled(this.getParentFolderNode() != null);
    }

    private void createMdsFolder() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            CreateMdsFolderDialog mdsFolderDialog = new CreateMdsFolderDialog(this.getParentFolderNode(), this.getMsg());
            mdsFolderDialog.setVisible(true);
            this.projectFolderCreated = mdsFolderDialog.getProjectFolderCreated();
        }
    }

    private MdsFolderNode getParentFolderNode() {
        MdsFolderNode mdsFolderNode = null;
        if (this.parentFolderNode != null) {
            mdsFolderNode = this.parentFolderNode;
        } else if (this.getSelection().as(MdsFolderNode.class) != null) {
            mdsFolderNode = (MdsFolderNode)this.getSelection().as(MdsFolderNode.class);
        }
        return mdsFolderNode;
    }
}

