/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.selection.Selection;
import oracle.ide.Context;
import oracle.mds.core.MDSInstance;
import oracle.mds.persistence.MetadataStore;
import oracle.mds.persistence.stores.db.DBMetadataStore;
import oracle.tip.tools.ide.common.resourcepalette.adapter.ConnectionsHelper;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSConnectionDescriptor;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSProvider;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.wizard.MDSConnectionWizard;
import org.jetbrains.annotations.NotNull;

public class ConfigureMdsConnectionAction
extends BaseAction {
    public ConfigureMdsConnectionAction() {
        super(FusionStudioMsg.CONFIGURE_MDS_CONNECTION_FAIL);
        this.requires(Void.class);
    }

    public void run() {
        this.configureMdsConnection();
    }

    public boolean configureMdsConnection() {
        ConfigureMdsConnectionDialog dialog = new ConfigureMdsConnectionDialog(Ui.getRoot(), this.getMsg(), true);
        dialog.setVisible(true);
        return dialog.userAccepted();
    }

    protected void updateEnableStatus(Selection s) {
        if (StudioMetadataService.getInstance().isStatusConnected()) {
            this.setMsg(FusionStudioMsg.CONFIGURE_MDS_CONNECTION_SUCCESS);
        } else {
            this.setMsg(FusionStudioMsg.CONFIGURE_MDS_CONNECTION_FAIL);
        }
    }

    private class ConfigureMdsConnectionDialog
    extends OkCancelDialog {
        private ComboBox<String> mdsConnectionsCombo;
        private static final String MDS_BPM_PARTITION_NAME = "obpm";

        public ConfigureMdsConnectionDialog(UiWindow owner, Msg msg, boolean modal) {
            super(owner, msg, modal);
            this.buildUi();
        }

        public void ok() {
            StudioMetadataService.getInstance().startStatusConnecting();
            String selectedMdsConnection = (String)this.mdsConnectionsCombo.getSelectedItem();
            try {
                MDSInstance mdsInstance = this.getMdsInstance(selectedMdsConnection);
                StudioMetadataService.getInstance().changeMdsInstance(mdsInstance);
            }
            catch (MetadataException e) {
                MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_ESTABLISHING_MDS_CONNECTION(e.getMessage()), (Throwable)e);
            }
            this.setVisible(false);
        }

        private MDSInstance getMdsInstance(@NotNull String selectedMdsConnection) {
            MDSInstance result = null;
            try {
                MDSProvider resourcePaletteProvider = (MDSProvider)ConnectionsHelper.getResourcePaletteProvider((String)selectedMdsConnection);
                MDSConnectionDescriptor connectionDesc = resourcePaletteProvider.getConnectionDescriptor();
                if (MDS_BPM_PARTITION_NAME.equals(connectionDesc.getMDS_PARTITION_NAME()) && resourcePaletteProvider.isDBMDSProvider()) {
                    DBMetadataStore store = new DBMetadataStore(resourcePaletteProvider.getDBUserId(), resourcePaletteProvider.getDBPassword(), connectionDesc.getDBMDS_JDBC_URL(), MDS_BPM_PARTITION_NAME);
                    return MdsInstanceInitializer.getMDSInstance((String)(MDS_BPM_PARTITION_NAME + selectedMdsConnection), (MetadataStore)store);
                }
                result = resourcePaletteProvider.getMDSInstance();
            }
            catch (Exception e) {
                MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_ESTABLISHING_MDS_CONNECTION(e.getMessage()), (Throwable)e);
            }
            return result;
        }

        private void buildUi() {
            Panel mainPanel = Panel.createPanelWithBorder((UiContainer)this.getContentPane());
            mainPanel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
            Label comboLabel = Label.create((UiContainer)mainPanel, (Msg)FusionStudioMsg.MDS_CONNECTIONS);
            this.mdsConnectionsCombo = new DbConnectionsCombo(mainPanel, this.getMdsConnections());
            this.mdsConnectionsCombo.setSelectedItem((Object)StudioMetadataService.getInstance().getCurrentMdsConnectionName());
            Button newMdsConnectionButton = Button.createIconic((UiContainer)mainPanel, (Msg)DesignerMsg.ADD);
            newMdsConnectionButton.addActionListener(this.getNewMdsConnectionActionListener());
            mainPanel.add((UiComponent)comboLabel);
            mainPanel.add(this.mdsConnectionsCombo, (Object)"growx, wmin 200");
            mainPanel.add((UiComponent)newMdsConnectionButton);
            this.setIconImage(Image.create((Msg)this.getMsg()));
            this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }

        private ActionListener getNewMdsConnectionActionListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MDSConnectionWizard mdsConnectionWizard = new MDSConnectionWizard();
                    mdsConnectionWizard.invoke(Context.newIdeContext());
                    ConfigureMdsConnectionDialog.this.updateConnections();
                }
            };
        }

        private void updateConnections() {
            for (String connection : this.getMdsConnections()) {
                if (this.mdsConnectionsCombo.containsItem((Object)connection)) continue;
                this.mdsConnectionsCombo.addItem((Object)connection);
                this.mdsConnectionsCombo.setSelectedItem((Object)connection);
            }
        }

        private List<String> getMdsConnections() {
            ArrayList<String> connections = new ArrayList<String>();
            try {
                List stringList = ConnectionsHelper.getResourcePaletteConnections(MDSProvider.class);
                for (String connectionName : stringList) {
                    MDSProvider provider = (MDSProvider)ConnectionsHelper.getResourcePaletteProvider((String)connectionName);
                    MDSConnectionDescriptor connectionDesc = provider.getConnectionDescriptor();
                    if (!MDS_BPM_PARTITION_NAME.equals(connectionDesc.getMDS_PARTITION_NAME())) continue;
                    connections.add(connectionName);
                }
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
            return connections;
        }

        private class DbConnectionsCombo
        extends ComboBox<String> {
            public DbConnectionsCombo(Panel mainPanel, Collection<String> dbConnections) {
                super((UiContainer)mainPanel, false);
                this.addItems(dbConnections);
            }
        }
    }
}

