/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import java.awt.Component;
import java.io.File;
import java.net.URI;
import oracle.bpm.fusion.studio.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.ui.ProjectNamePanel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class CheckoutMdsProjectDialog
extends OkCancelDialog {
    private MdProject<? extends ProjectArtifact> mdsProject;
    private ProjectNamePanel projectNamePanel;

    public CheckoutMdsProjectDialog(UiWindow parent, MdProject<? extends ProjectArtifact> mdsProject) {
        super(parent, FusionStudioMsg.CHECKOUT_MDS_PROJECT, true);
        this.mdsProject = mdsProject;
        this.buildUi();
    }

    public void ok() {
        FuegoWorker.post((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)CheckoutMdsProjectDialog.this.getContentPane().asSwing(), FusionStudioMsg.CHECKING_OUT_PROJECT.toString());
                progressMonitor.setCancellable(false);
                progressMonitor.start();
                try {
                    int answer;
                    PublicShareProject publicShareProject;
                    Project project = (Project)CheckoutMdsProjectDialog.this.mdsProject.getProject().get();
                    String projectName = CheckoutMdsProjectDialog.this.projectNamePanel.getProjectName();
                    URI baseLocation = new File(CheckoutMdsProjectDialog.this.getRootDir(), projectName).toURI();
                    boolean isTemplate = project.isTemplate();
                    if (!isTemplate && !(publicShareProject = (PublicShareProject)CheckoutMdsProjectDialog.this.mdsProject).isLocked() && (answer = MessageDialog.showQuestion((Msg)FusionStudioMsg.PROJECT_LOCKING, (Msg)FusionStudioMsg.ASK_FOR_PROJECT_LOCKING, (int)6)) == 2) {
                        StudioMetadataService.getInstance().getService().acquireLock((PublicShareProject)CheckoutMdsProjectDialog.this.mdsProject, "BPM Studio");
                        MdsProjectNavigatorManager.getInstance().refresh();
                    }
                    Project createdProject = RepositoryService.getInstance().getActiveRepository().create(project, baseLocation, projectName);
                    if (!isTemplate) {
                        ProjectPreferences preferences = createdProject.getPreferences();
                        preferences.setTemplate(false);
                        createdProject.getWriter().write(new ProjectObject[]{preferences});
                    }
                }
                catch (MetadataException e) {
                    MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_CHECKINGOUT_MDS_PROJECT(e.getMessage()));
                    throw ProgramException.wrap("Problems while getting the project from MDS.", e);
                }
                catch (ProjectException e) {
                    MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_CHECKINGOUT_MDS_PROJECT(e.getMessage()));
                }
                finally {
                    CheckoutMdsProjectDialog.this.setVisible(false);
                    progressMonitor.finish();
                }
            }
        });
    }

    private void buildUi() {
        StandardForm standardForm = FormsFactory.createStandardForm((UiContainer)this.getContentPane());
        this.projectNamePanel = new ProjectNamePanel(this.getContentPane(), this.getInitialProjectName());
        standardForm.add((UiComponent)this.projectNamePanel);
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private String getInitialProjectName() {
        return this.mdsProject.getName();
    }

    private String getRootDir() {
        return Ide.getActiveWorkspace().getBaseDirectory();
    }
}

