/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds;

import oracle.bpm.fusion.studio.mds.CheckoutMdsProjectDialog;
import oracle.bpm.fusion.studio.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;
import oracle.ide.Ide;

public class CheckoutMdsProjectAction
extends BaseAction {
    private MdProject<? extends ProjectArtifact> mdsProject;

    public CheckoutMdsProjectAction() {
        super(FusionStudioMsg.CHECKOUT_MDS_PROJECT);
        this.requires(MdProject.class);
    }

    public CheckoutMdsProjectAction(MdProject<? extends ProjectArtifact> mdsProject) {
        this();
        this.mdsProject = mdsProject;
    }

    public void run() {
        this.checkoutProject();
    }

    private void checkoutProject() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else if (Ide.getActiveWorkspace() == null) {
            MessageDialog.showError((Msg)FusionStudioMsg.NO_APPLICATION_OPENED);
        } else {
            PublicShareProject publicShareProject;
            ProjectArtifact projectArtifact = this.getProjectArtifact();
            if (projectArtifact instanceof PublicShareProject && (publicShareProject = (PublicShareProject)projectArtifact).isLocked()) {
                int answer;
                String string = publicShareProject.getUserLock();
                StudioMetadataService.getInstance().getService();
                if (!string.equals("BPM Studio") && (answer = MessageDialog.showQuestion((Msg)this.getMsg(), (Msg)FusionStudioMsg.PROJECT_IS_LOCKED_BY_COMPOSER_USER, (int)0x1000006)) != 2) {
                    return;
                }
            }
            CheckoutMdsProjectDialog checkoutMdsProjectDialog = new CheckoutMdsProjectDialog(Ui.getRoot(), this.mdsProject);
            checkoutMdsProjectDialog.setVisible(true);
        }
    }

    private ProjectArtifact getProjectArtifact() {
        return (ProjectArtifact)this.mdsProject.getLocalRef().get();
    }
}

