/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.help;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.bpm.ui.help.HelpService;
import oracle.ide.help.HelpSystem;

public class JdevHelpService
implements HelpService {
    private Properties properties;
    private static final String DEFAULT_ID = "BPM.Studio";
    private static final String DEFAULT_REAL_ID = "pref_studio_olh.htm";

    public void showHelp(String id) {
        String safeId = JdevHelpService.getSafeId(id);
        HelpSystem.getHelpSystem().goTo(this.getRealHelpId(safeId));
    }

    public boolean isValidHelpId(String id) {
        return this.existRealHelpId(id) && HelpSystem.getHelpSystem().doesTopicExist(this.getRealHelpId(id));
    }

    public boolean existRealHelpId(String id) {
        return this.getRealHelpId(id) != null;
    }

    public String getRealHelpId(String id) {
        return id != null ? (String)this.getProperties().get(id) : null;
    }

    public void setRealHelpId(String id, String realId) {
        if (id != null) {
            this.getProperties().setProperty(id, realId);
        }
    }

    private static String getSafeId(String id) {
        return id != null ? id : DEFAULT_ID;
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    private Properties loadProperties() {
        InputStream inputStream = this.getClass().getResourceAsStream("/help.properties");
        Properties properties = new Properties();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                properties.put(DEFAULT_ID, DEFAULT_REAL_ID);
            }
        } else {
            properties.put(DEFAULT_ID, DEFAULT_REAL_ID);
        }
        return properties;
    }
}

