/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ExpressionBuilder;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.xmlschema.SFSNamespace;
import oracle.ide.Ide;
import oracle.tip.tools.ide.common.expressionbuilders.Variable;
import oracle.tip.tools.ide.common.expressionbuilders.VariableExpressionBuilder;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolverImpl;
import org.jetbrains.annotations.NotNull;

public class XPathVariableExpressionBuilder
implements ExpressionBuilder {
    private VariableExpressionBuilder expressionBuilder;
    private static URL XML_SCHEMA;
    public static final int OK = 0;
    public static final int CANCEL = 1;

    private XPathVariableExpressionBuilder(List<Variable> variables) {
        this.expressionBuilder = new VariableExpressionBuilder(null, variables);
    }

    private XPathVariableExpressionBuilder(List<Variable> variables, String initXPath, MapperNSResolver mapper) {
        this.expressionBuilder = new VariableExpressionBuilder(null, variables, initXPath, mapper);
    }

    public static XPathVariableExpressionBuilder create(@NotNull DataDeclarationContainer variablesContext) {
        return XPathVariableExpressionBuilder.create(variablesContext, (Expression)null);
    }

    public static XPathVariableExpressionBuilder create(@NotNull DataDeclarationContainer variablesContext, String expression) {
        List<Variable> variables = XPathVariableExpressionBuilder.buildVariablesList(variablesContext);
        return new XPathVariableExpressionBuilder(variables, expression, (MapperNSResolver)new MapperNSResolverImpl());
    }

    public static XPathVariableExpressionBuilder create(@NotNull DataDeclarationContainer variablesContext, Expression expression) {
        List<Variable> variables = XPathVariableExpressionBuilder.buildVariablesList(variablesContext);
        MapperNSResolverImpl resolver = null;
        if (expression != null) {
            Map<String, URI> map = expression.getNamespaces();
            resolver = new MapperNSResolverImpl();
            for (String id : map.keySet()) {
                resolver.addNSEntry(id, map.get(id).toString());
            }
        }
        XPathVariableExpressionBuilder builder = resolver != null ? new XPathVariableExpressionBuilder(variables, expression.getExpressionValue(), (MapperNSResolver)resolver) : new XPathVariableExpressionBuilder(variables);
        return builder;
    }

    public Expression getExpression() {
        MapperNSResolver nsResolver = this.expressionBuilder.getNamespaceResolver();
        return new XPathExpression(this.expressionBuilder.getExpressionText(), this.getNSMapFor(nsResolver));
    }

    public boolean showDialog() {
        int result = this.expressionBuilder.display();
        return result == 0;
    }

    private static List<Variable> buildVariablesList(@NotNull DataDeclarationContainer variablesContext) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Sequence dataDeclarations = variablesContext.getDeclarations();
        for (DataDeclaration dataDeclaration : dataDeclarations) {
            Variable v = null;
            CatalogType typeDescription = dataDeclaration.getType();
            SchemaObject schemaObject = typeDescription.getDelegate().asSchemaObject();
            if (schemaObject.isBasicType()) {
                v = new Variable(dataDeclaration.getName(), 3, XPathVariableExpressionBuilder.getPrimitiveTypeQName(dataDeclaration.getType().getDelegate()), 2, XML_SCHEMA);
            } else {
                VFile file = schemaObject.getResourceLocation();
                if (file != null) {
                    URL fileURL = XPathVariableExpressionBuilder.getFileURL(file);
                    int type = schemaObject.isElement() ? 2 : 3;
                    int source = schemaObject.isFromSchema() ? 2 : 1;
                    v = new Variable(dataDeclaration.getName(), type, new QName(schemaObject.getNamespace(), schemaObject.getName()), source, fileURL);
                }
            }
            if (v == null) continue;
            variables.add(v);
        }
        return variables;
    }

    private static QName getPrimitiveTypeQName(@NotNull TypeDescription primitiveTypeDescription) {
        String typeName = SFSNamespace.S2001_NAMESPACE.lookupTypeName(primitiveTypeDescription);
        QName qName = null;
        if (!Str.isEmpty(typeName)) {
            qName = new QName("http://www.w3.org/2001/XMLSchema", typeName);
        }
        return qName;
    }

    private static URL getFileURL(@NotNull VFile file) {
        URL result;
        try {
            VFileSystem fs = file.getFileSystem();
            result = ((JavaFileSystem)fs).toJavaFile(file).toURI().toURL();
        }
        catch (MalformedURLException e1) {
            throw new RuntimeException(e1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private Map<String, URI> getNSMapFor(MapperNSResolver nsResolver) {
        String[][] entries = nsResolver.getAllNSEntries();
        HashMap<String, URI> nsMap = new HashMap<String, URI>();
        for (String[] entry : entries) {
            nsMap.put(entry[0], URI.create(entry[1]));
        }
        if (nsMap.get("bpmn") == null) {
            nsMap.put("bpmn", URI.create("http://www.omg.org/bpmn20"));
        }
        return nsMap;
    }

    static {
        try {
            String homePath = Ide.getProductHomeDirectory();
            File schema = new File(homePath, "../libraries/schemas/xsd/XMLSchema.xsd");
            XML_SCHEMA = schema.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            XML_SCHEMA = null;
        }
    }
}

