/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.JTextComponent;
import oracle.bpm.fusion.studio.expressionbuilder.DataDeclarationsPicker;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.ExpressionBuilderUsecases;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolverImpl;
import org.jetbrains.annotations.NotNull;

public class XPathExpressionBuilder
extends ExpressionBuilder
implements oracle.bpm.designer.ExpressionBuilder {
    private DataDeclarationContainer context;
    private DataDeclarationsPicker dataDeclarationsPicker;
    private MapperNSResolver namespaceResolver;
    private static final long serialVersionUID = -7315814121122968428L;

    private XPathExpressionBuilder(@NotNull JTextComponent editor, @NotNull DataDeclarationsPicker dataDeclarationsPicker, @NotNull FunctionsExpressionBuilderPicker functionsPicker, @NotNull MapperNSResolver namespaceResolver, @NotNull DataDeclarationContainer context) {
        super(null, editor, new ExpressionBuilderPicker[]{dataDeclarationsPicker, functionsPicker});
        this.dataDeclarationsPicker = dataDeclarationsPicker;
        this.namespaceResolver = namespaceResolver;
        this.context = context;
    }

    public static XPathExpressionBuilder create(@NotNull DataDeclarationContainer context, Expression expression) {
        XPathEditorPane editor = ExpressionBuilderUsecases.createXPathEditor((int)5);
        MapperNSResolverImpl namespaceResolver = new MapperNSResolverImpl();
        if (expression != null) {
            Map<String, URI> map = expression.getNamespaces();
            for (String id : map.keySet()) {
                namespaceResolver.addNSEntry(id, map.get(id).toString());
            }
        }
        DataDeclarationsPicker dataDeclarationsPicker = new DataDeclarationsPicker(context, ExpressionMode.XPATH);
        FunctionsExpressionBuilderPicker functionsPicker = ExpressionBuilderUsecases.createFunctionsExpressionBuilderPicker((NamespaceResolver)namespaceResolver, (int)5);
        functionsPicker.load();
        dataDeclarationsPicker.setUsedNamespaces(XPathExpressionBuilder.getNSMapFor((MapperNSResolver)namespaceResolver));
        if (expression != null) {
            String expressionText = expression.getExpressionValue();
            editor.setText(expressionText);
        }
        return new XPathExpressionBuilder((JTextComponent)editor, dataDeclarationsPicker, functionsPicker, (MapperNSResolver)namespaceResolver, context);
    }

    public Expression getExpression() {
        String expressionText = this.getExpressionText();
        if (Str.isEmpty(expressionText)) {
            return null;
        }
        XPathExpression expression = new XPathExpression(expressionText, this.getAllUsedNamespaces());
        return ExpressionHelper.getPurgedExpression((XPathExpression)expression, (DataDeclarationContainer)this.context);
    }

    public boolean showDialog() {
        int result = this.display();
        return result == 0;
    }

    public String getExpressionText() {
        String exp = super.getExpressionText();
        int searchStart = 0;
        while (true) {
            int leftBracketIndex = exp.indexOf("{", searchStart);
            int rightBracketIndex = exp.indexOf("}", leftBracketIndex + 1);
            if (leftBracketIndex < 0 || rightBracketIndex <= leftBracketIndex) break;
            String namespace = exp.substring(leftBracketIndex + 1, rightBracketIndex);
            if (namespace.trim().length() > 1) {
                String prefix = this.namespaceResolver.addNSEntry(null, namespace);
                exp = exp.replace("{" + namespace + "}", prefix);
            }
            searchStart = leftBracketIndex + 1;
        }
        return exp;
    }

    private static Map<String, URI> getNSMapFor(MapperNSResolver nsResolver) {
        String[][] entries = nsResolver.getAllNSEntries();
        HashMap<String, URI> nsMap = new HashMap<String, URI>();
        for (String[] entry : entries) {
            nsMap.put(entry[0], URI.create(entry[1]));
        }
        nsMap.put("bpmn", URI.create("http://www.omg.org/bpmn20"));
        return nsMap;
    }

    private Map<String, URI> getAllUsedNamespaces() {
        HashMap<String, URI> result = new HashMap<String, URI>();
        Map<String, URI> editorNamespaces = XPathExpressionBuilder.getNSMapFor(this.namespaceResolver);
        Map<String, URI> draggedNamespaces = this.dataDeclarationsPicker.getUsedNamespaces();
        result.putAll(editorNamespaces);
        result.putAll(draggedNamespaces);
        return result;
    }
}

