/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionField;
import oracle.bpm.fusion.studio.codeeditor.FusionCodeEditor;
import oracle.bpm.fusion.studio.expressionbuilder.DataDeclarationsPicker;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import org.jetbrains.annotations.NotNull;

public class SimpleExpressionBuilder
extends ExpressionBuilder
implements oracle.bpm.designer.ExpressionBuilder {
    private DataDeclarationContainer context;
    private FusionCodeEditor editor;
    private final ExpressionField.ExpressionFieldMode fieldMode;
    private CatalogType resultType;
    private static final long serialVersionUID = -7315814121122968428L;

    private SimpleExpressionBuilder(@NotNull DataDeclarationContainer context, CatalogType resultType, @NotNull FusionCodeEditor editor, @NotNull DataDeclarationsPicker picker, @NotNull ExpressionField.ExpressionFieldMode fieldMode) {
        super(null, (JTextComponent)editor.getTextEditor(), new ExpressionBuilderPicker[]{picker});
        this.context = context;
        this.resultType = resultType;
        this.editor = editor;
        this.fieldMode = fieldMode;
        this.setHelpID("f1_bpm_expressionbuilderd_html");
    }

    public static SimpleExpressionBuilder create(@NotNull DataDeclarationContainer context, CatalogType resultType, Expression expression, @NotNull ExpressionField.ExpressionFieldMode fieldMode) {
        FusionCodeEditor editor = new FusionCodeEditor(context, resultType);
        if (expression != null) {
            String text = ExpressionHelper.getText((Expression)expression, (DataDeclarationContainer)context, (CatalogType)resultType);
            editor.setText(text);
        }
        DataDeclarationsPicker picker = new DataDeclarationsPicker(context, ExpressionMode.SIMPLE);
        return new SimpleExpressionBuilder(context, resultType, editor, picker, fieldMode);
    }

    public Expression getExpression() {
        String expressionString = this.getExpressionString();
        if (Str.isEmpty(expressionString)) {
            return null;
        }
        boolean isLValue = this.fieldMode == ExpressionField.ExpressionFieldMode.QUERY;
        CatalogType type = !isLValue ? this.resultType : null;
        return ExpressionHelper.createSimpleExpression((String)expressionString, (DataDeclarationContainer)this.context, (CatalogType)type, null);
    }

    public boolean showDialog() {
        return this.display() == 0;
    }

    private String getExpressionString() {
        try {
            return new String(this.editor.getEditorDocument().getChars());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }
}

