/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationTreeNode;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsPanel;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationsPanelModelListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.PredefinedDeclaration;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.tree.TreeNode;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPickerListener;
import oracle.tip.tools.ide.common.expressionbuilder.PickerEvent;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationsPicker
implements ExpressionBuilderPicker {
    private DataDeclarationsPanel dataDeclarationsPanel;
    private ArrayList<ExpressionBuilderPickerListener> listeners = new ArrayList();
    private JScrollPane scrollPane;

    public DataDeclarationsPicker(@NotNull DataDeclarationContainer context, @NotNull ExpressionMode mode) {
        this.dataDeclarationsPanel = new DataDeclarationsPanel(null, context, DataDeclarationsPanel.DataDeclarationsPanelMode.SELECTABLE_MODE, true);
        this.dataDeclarationsPanel.addSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DataDeclarationsPicker.this.fireSelectionChange();
            }
        });
        this.dataDeclarationsPanel.setExpressionMode(mode);
        this.scrollPane = new JScrollPane(this.dataDeclarationsPanel.asSwing());
    }

    public String getTitle() {
        return DesignerMsg.VARIABLES.getString();
    }

    public void load() {
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void addExpressionBuilderPickerListener(ExpressionBuilderPickerListener expressionBuilderPickerListener) {
        this.listeners.add(expressionBuilderPickerListener);
    }

    public void removeExpressionBuilderPickerListener(ExpressionBuilderPickerListener expressionBuilderPickerListener) {
        this.listeners.remove(expressionBuilderPickerListener);
    }

    public void addModelListener(DataDeclarationsPanelModelListener listener) {
        this.dataDeclarationsPanel.addModelListener(listener);
    }

    public void removeModelListener(DataDeclarationsPanelModelListener listener) {
        this.dataDeclarationsPanel.removeModelListener(listener);
    }

    public void setUsedNamespaces(Map<String, URI> usedNamespaces) {
        this.dataDeclarationsPanel.setUsedNamespaces(usedNamespaces);
    }

    public Map<String, URI> getUsedNamespaces() {
        return this.dataDeclarationsPanel.getUsedNamespaces();
    }

    private void fireSelectionChange() {
        String preview = "";
        String description = "";
        TreeNode selectedTreeNode = this.dataDeclarationsPanel.getSelectedNode();
        if (selectedTreeNode != null && selectedTreeNode instanceof DataDeclarationTreeNode) {
            DataDeclarationTreeNode dataDeclarationTreeNode = (DataDeclarationTreeNode)selectedTreeNode;
            DataDeclaration dataDeclaration = dataDeclarationTreeNode.getDataDeclaration();
            description = this.getDescription(dataDeclaration);
            preview = dataDeclarationTreeNode.getFullPathText();
        }
        PickerEvent event = new PickerEvent((Object)this, 0);
        event.setDescription(description);
        event.setPreview(preview);
        for (ExpressionBuilderPickerListener listener : this.listeners) {
            listener.pickerEventOccurred(event);
        }
    }

    private String getDescription(@NotNull DataDeclaration dataDeclaration) {
        return dataDeclaration.isPredefinedDeclaration() ? ((PredefinedDeclaration)dataDeclaration).getDescription().getString() : dataDeclaration.getDeclarationType().getString();
    }
}

