/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.editor;

import javax.xml.namespace.QName;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import org.jetbrains.annotations.NotNull;

class DetailsPanel
extends Panel {
    public DetailsPanel(@NotNull UiContainer parent, @NotNull CatalogObject catalogObject) {
        super(parent);
        this.setBackground(Color.WHITE);
        this.init(catalogObject);
    }

    private void init(@NotNull CatalogObject catalogObject) {
        TypeDescription td = catalogObject.getDelegate();
        if (td.isSchemaObject()) {
            if (catalogObject.isService()) {
                this.createPanelForService(td);
            } else {
                this.createPanelForXmlSchema(td);
            }
        }
    }

    private void createPanelForService(@NotNull TypeDescription td) {
        String cols = "2dlu, pref, 5dlu, pref, 5dlu";
        String rows = "0dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout("2dlu, pref, 5dlu, pref, 5dlu", "0dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        CellConstraints cc = layout.createCellConstraints();
        this.setLayout((Layout)layout);
        ServiceObject serviceObject = td.asServiceObject();
        String originalResourceLocation = serviceObject.getServiceLocation();
        String qname = serviceObject.getServiceQName().toString();
        String target = serviceObject.getTarget();
        String targetPort = serviceObject.getTargetPort();
        String serviceData = targetPort != null ? target + "." + targetPort : target;
        String callback = null;
        QName callbackQName = serviceObject.getCallbackServiceQName();
        if (callbackQName != null) {
            callback = callbackQName.toString();
        }
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.SERVICE_DATA), cc.xy(2, 2));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(serviceData)), cc.xy(4, 2));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.SERVICE_QNAME), cc.xy(2, 4));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(qname)), cc.xy(4, 4));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.CALLBACK_SERVICE_QNAME), cc.xy(2, 6));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(callback)), cc.xy(4, 6));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.BASED_ON_RESOURCE), cc.xy(2, 8));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(originalResourceLocation)), cc.xy(4, 8));
    }

    private void createPanelForXmlSchema(@NotNull TypeDescription td) {
        String cols = "2dlu, pref, 5dlu, pref, 5dlu";
        String rows = "0dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout("2dlu, pref, 5dlu, pref, 5dlu", "0dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        CellConstraints cc = layout.createCellConstraints();
        this.setLayout((Layout)layout);
        SchemaObject schemaObject = td.asSchemaObject();
        String qname = "{" + schemaObject.getNamespace() + "}" + schemaObject.getName();
        String type = schemaObject.getXmlElementType().toString();
        String originalResource = schemaObject.getLocation();
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.QNAME), cc.xy(2, 2));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(qname)), cc.xy(4, 2));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TYPE), cc.xy(2, 4));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(type)), cc.xy(4, 4));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.BASED_ON_RESOURCE), cc.xy(2, 6));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(originalResource)), cc.xy(4, 6));
    }
}

