/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.editor;

import java.awt.Component;
import java.awt.Dimension;
import oracle.bpm.designer.catalogdoc.DocumentationEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CloseableDialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.SwingFactory;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.documentation.Documentable;

public class DescriptionEditorPanel
extends Panel {
    private Descriptable descriptable;
    private TextField descriptionTextField;
    private Button documentationButton;

    public DescriptionEditorPanel(UiContainer parent) {
        super(parent);
        this.init();
    }

    public void load(Descriptable descriptable) {
        if (descriptable == null) {
            throw new IllegalArgumentException("Null descriptable");
        }
        this.descriptable = descriptable;
        this.load();
    }

    public void store() {
        if (this.descriptable == null) {
            throw new IllegalArgumentException("Load was not called");
        }
        this.descriptable.setDescription(this.descriptionTextField.getText());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionTextField.setEnabled(enabled);
        this.documentationButton.setEnabled(enabled);
    }

    private void init() {
        String cols = "2dlu, max(80px;pref), 5dlu, pref,4dlu,pref:grow,2dlu:grow";
        String rows = "0dlu, pref,2dlu, pref, 0dlu";
        FormLayout layout = new FormLayout(cols, rows);
        CellConstraints cc = layout.createCellConstraints();
        this.setLayout((Layout)layout);
        this.documentationButton = new Button((UiContainer)this, UIMsg.EDIT);
        this.documentationButton.setShowDialog(true);
        this.documentationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptionEditorPanel.this.showDocumentationDialog();
            }
        });
        this.descriptionTextField = new TextField((UiContainer)this, 50);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.DESCRIPTION), cc.xy(2, 2));
        this.add((UiComponent)this.descriptionTextField, cc.xyw(4, 2, 3));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.DOCUMENTATION), cc.xy(2, 4));
        this.add((UiComponent)this.documentationButton, cc.xy(4, 4));
    }

    private void showDocumentationDialog() {
        DocumentationDialog dialog = new DocumentationDialog(Ui.getRoot(), this.descriptable);
        dialog.setVisible(true);
    }

    private void load() {
        this.descriptionTextField.setText(this.descriptable.getDescription());
    }

    private static class DocumentationDialog
    extends CloseableDialog {
        private DocumentationEditorPanel documentationEditorPanel;

        public DocumentationDialog(UiWindow parent, Descriptable descriptable) {
            super(parent, DesignerMsg.DOCUMENTATION);
            this.init(descriptable);
        }

        public void ok() {
            this.documentationEditorPanel.storeDocumentation();
            this.close();
        }

        private void init(Descriptable descriptable) {
            UiContainer container = this.getContentPane();
            this.documentationEditorPanel = DocumentationEditorPanel.create((Documentable)descriptable.getDocumentable());
            Dimension pref = this.documentationEditorPanel.getPreferredSize();
            this.documentationEditorPanel.setPreferredSize(new Dimension(pref.width, Math.max(pref.height, 300)));
            UiComponent component = SwingFactory.createFrom((Component)this.documentationEditorPanel);
            container.add(component, (Object)"Center");
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }
    }

    public static interface Descriptable {
        public void setDescription(String var1);

        public String getDescription();

        public Documentable getDocumentable();

        public ProjectObject getProjectObject();
    }
}

