/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.designer.action.NewAttributeAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.TypeChooserPanel;
import oracle.bpm.fusion.studio.editor.AttributePanel;
import oracle.bpm.fusion.studio.editor.DescriptionEditorPanel;
import oracle.bpm.fusion.studio.editor.DetailsPanel;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.documentables.DocumentableFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.SwingFactory;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.documentation.Documentable;
import oracle.tip.tools.ide.common.ui.collapsabletabpane.CollapsableTabPane;
import oracle.tip.tools.ide.common.ui.collapsabletabpane.TabData;

public class BusinessObjectEditor
extends CatalogObjectEditor {
    private CollapsableTabPane attributeCollapsable;
    private Map<CatalogMember, TabData> attributeTabs = new HashMap<CatalogMember, TabData>();
    private DescriptionEditorPanel descriptionEditorPanel;
    private UiContainer uiParent;

    protected BusinessObjectEditor(UiContainer parent, final CatalogObject catalogObject) {
        super(parent, catalogObject);
        ProjectListenerAdapter<CatalogMember> projectListener = new ProjectListenerAdapter<CatalogMember>(CatalogMember.class){

            public void postObjectAdded(CatalogMember object, ProjectObject parent) {
                if (object.getParentObject() == catalogObject) {
                    BusinessObjectEditor.this.rebuild();
                }
            }

            public void postObjectRemoved(CatalogMember object, ProjectObject parent) {
                if (object.getParentObject() == catalogObject) {
                    BusinessObjectEditor.this.rebuild();
                }
            }

            public void objectChanged(CatalogMember object, ProjectEvent event) {
                TabData tab;
                if (object.getParentObject() == catalogObject && (tab = (TabData)BusinessObjectEditor.this.attributeTabs.get(object)) != null) {
                    tab.setTitle(BusinessObjectEditor.this.createMsgFromMember(object));
                    BusinessObjectEditor.this.attributeCollapsable.refresh(tab);
                }
            }
        };
        ProjectListenerAdapter<CatalogObject> projectListener2 = new ProjectListenerAdapter<CatalogObject>(CatalogObject.class){

            public void objectChanged(CatalogObject object, ProjectEvent event) {
                if (object == catalogObject && "swap_children".equals(event.getPropertyName())) {
                    BusinessObjectEditor.this.rebuild();
                }
            }
        };
        catalogObject.getProject().addListener((ProjectListener)projectListener);
        catalogObject.getProject().addListener((ProjectListener)projectListener2);
    }

    public EditorType getEditorType() {
        return EditorType.COMPONENT;
    }

    public void load() {
        final CatalogObject projectObject = (CatalogObject)this.getProjectObject();
        this.descriptionEditorPanel.load(new DescriptionEditorPanel.Descriptable(){

            @Override
            public void setDescription(String description) {
                projectObject.getObjectType().setDescription(description);
            }

            @Override
            public String getDescription() {
                return projectObject.getObjectType().getDescription();
            }

            @Override
            public Documentable getDocumentable() {
                return DocumentableFactory.create((CatalogType)projectObject);
            }

            @Override
            public ProjectObject getProjectObject() {
                return projectObject;
            }
        });
        this.descriptionEditorPanel.setEnabled(!projectObject.isReadOnly());
    }

    public void openPart(Object part) {
    }

    protected void buildUI(UiContainer parent) {
        this.uiParent = parent;
        parent.setLayout((Layout)new BorderLayout());
        parent.setBackground(oracle.bpm.draw.Color.WHITE);
        CollapsableTabPane collapsable = new CollapsableTabPane();
        collapsable.setOpaque(true);
        collapsable.setScrollingEnabled(false);
        collapsable.setBackground(Color.WHITE);
        ((JComponent)parent.getNative()).add((Component)collapsable, "Center");
        UiContainer uiCollapsable = (UiContainer)SwingFactory.createFrom((Component)collapsable);
        Panel propertiesPanel = this.buildProperties(uiCollapsable);
        this.initPanel(propertiesPanel);
        TabData properties = new TabData(null, ((CatalogObject)this.getProjectObject()).isException() ? DesignerMsg.NEW_BUSINESS_EXCEPTION.toString() : BpmObjectMsg.BPM_OBJECT.toString(), null, (JComponent)propertiesPanel.getNative(), null, null);
        properties.setCollapsable(false);
        collapsable.addTab(properties);
        DetailsPanel detailsPanel = new DetailsPanel(uiCollapsable, (CatalogObject)this.getProjectObject());
        TabData details = new TabData(null, DesignerMsg.DETAILS.toString(), null, (JComponent)detailsPanel.getNative(), null, null);
        collapsable.addTab(details);
        collapsable.closeTab(details);
        TabData attributes = this.buildAttributes();
        collapsable.addTab(attributes);
    }

    protected void editorToObject() {
        this.store();
    }

    protected void objectToEditor() {
        this.load();
    }

    private void rebuild() {
        this.uiParent.removeAll();
        this.buildUI(this.uiParent);
        this.objectToEditor();
        this.uiParent.revalidate();
    }

    private void store() {
        this.descriptionEditorPanel.store();
    }

    private Panel buildProperties(UiContainer parent) {
        this.descriptionEditorPanel = new DescriptionEditorPanel(parent);
        return this.descriptionEditorPanel;
    }

    private TabData buildAttributes() {
        CatalogObject projectObject = (CatalogObject)this.getProjectObject();
        Sequence attributes = projectObject.getAttributes();
        List<CatalogMember> memberList = CollectionUtils.sort(attributes, new Comparator<CatalogMember>(){

            @Override
            public int compare(CatalogMember o1, CatalogMember o2) {
                return new Integer(o1.getPosition()).compareTo(new Integer(o2.getPosition()));
            }
        });
        this.attributeCollapsable = this.createAccordeon();
        for (CatalogMember attribute : memberList) {
            this.buildAttribute(this.attributeCollapsable, attribute);
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        NewAttributeAction addAction = new NewAttributeAction(projectObject);
        addAction.setMsg(UIMsg.ADD_DETAIL((String)DesignerMsg.ADD_ATTRIBUTE.toString()));
        actions.add(this.adapt((BaseAction)addAction));
        return new TabData(null, DesignerMsg.ATTRIBUTES.toString(), null, (JComponent)this.attributeCollapsable, actions, null);
    }

    private Action adapt(BaseAction action) {
        boolean hasMsg;
        boolean bl = hasMsg = action.getMsg() != null;
        if (action.getSmallIcon() != null) {
            action.putValue("SmallIcon", (Object)action.getSmallIcon().asSwingIcon());
        } else if (hasMsg) {
            action.putValue("Name", (Object)action.getMsg().toString());
        }
        if (hasMsg) {
            action.putValue("ShortDescription", (Object)action.getMsg().getDetail());
        }
        return action;
    }

    private CollapsableTabPane createAccordeon() {
        CollapsableTabPane tabbed = new CollapsableTabPane();
        tabbed.setScrollingEnabled(false);
        tabbed.setOpaque(true);
        tabbed.setBackground(Color.WHITE);
        return tabbed;
    }

    private TabData addCollapsedTab(CollapsableTabPane collapsable, String msg, Panel panel) {
        return this.addCollapsedTab(collapsable, msg, panel, null);
    }

    private TabData addCollapsedTab(CollapsableTabPane collapsable, String msg, Panel panel, List<Action> actions) {
        this.initPanel(panel);
        TabData tabData = new TabData(null, msg, null, (JComponent)panel.getNative(), actions, null);
        Font font = tabData.getTitleFont();
        tabData.setTitleFont(font.deriveFont(0));
        collapsable.addTab(tabData);
        collapsable.closeTab(tabData);
        return tabData;
    }

    private TabData buildMethods() {
        Sequence methods = ((CatalogObject)this.getProjectObject()).getMethods();
        CollapsableTabPane methodCollapsable = this.createAccordeon();
        for (CatalogMember method : methods) {
            this.buildMethod(methodCollapsable, method);
        }
        return new TabData(null, DesignerMsg.METHODS.toString(), null, (JComponent)methodCollapsable, null, null);
    }

    private void buildAttribute(CollapsableTabPane collapsable, CatalogMember member) {
        String msg = this.createMsgFromMember(member);
        UiContainer uiCollapsable = (UiContainer)SwingFactory.createFrom((Component)collapsable);
        AttributePanel panel = new AttributePanel(uiCollapsable, member);
        ArrayList<Action> actions = new ArrayList<Action>();
        DeleteObjectAction removeAction = DeleteActionFactory.getDeleteActionFor((ProjectObject)member, (String)DesignerMsg.REMOVE_ATTRIBUTE.toString());
        MoveUpAction moveUpAction = new MoveUpAction();
        MoveDownAction moveDownAction = new MoveDownAction();
        actions.add(this.adapt((BaseAction)removeAction));
        actions.add(this.adapt(moveUpAction));
        actions.add(this.adapt(moveDownAction));
        Selection selection = DefaultSelection.createSingle((Object)member);
        moveUpAction.setSelection(selection);
        moveDownAction.setSelection(selection);
        TabData tab = this.addCollapsedTab(collapsable, msg, (Panel)panel, actions);
        this.attributeTabs.put(member, tab);
    }

    private String createMsgFromMember(CatalogMember member) {
        StringBuffer msg = new StringBuffer();
        msg.append(member.getType().getText());
        msg.append(" ");
        msg.append(member.getName());
        boolean required = member.isRequired();
        if (required) {
            msg.append(" (");
            msg.append(DesignerMsg.NOT_NULL);
            msg.append(")");
        }
        return msg.toString();
    }

    private void initPanel(Panel panel) {
        panel.setOpaque(true);
        panel.setBackground(oracle.bpm.draw.Color.WHITE);
        List childs = panel.getChildren();
        for (UiComponent child : childs) {
            if (child instanceof Panel) {
                this.initPanel((Panel)child);
                continue;
            }
            this.setOpaque(false);
        }
    }

    private void buildMethod(CollapsableTabPane collapsable, CatalogMember method) {
        StringBuffer msg = new StringBuffer();
        msg.append(method.getMemberType().getText());
        UiContainer uiCollapsable = (UiContainer)SwingFactory.createFrom((Component)collapsable);
        MethodPanel panel = new MethodPanel(uiCollapsable, method);
        panel.load();
        this.addCollapsedTab(collapsable, msg.toString(), panel);
    }

    private static class MethodPanel
    extends Panel {
        private DescriptionEditorPanel descriptionEditorPanel;
        private CatalogMember method;
        private TypeChooserPanel resultTypeChooser;

        public MethodPanel(UiContainer parent, CatalogMember method) {
            super(parent);
            this.method = method;
            this.setBackground(oracle.bpm.draw.Color.WHITE);
            this.init();
        }

        public void load() {
            this.descriptionEditorPanel.load(new DescriptionEditorPanel.Descriptable(){

                @Override
                public void setDescription(String description) {
                    MethodPanel.this.method.getMemberType().setDescription(description);
                }

                @Override
                public String getDescription() {
                    return MethodPanel.this.method.getMemberType().getDescription();
                }

                @Override
                public Documentable getDocumentable() {
                    return DocumentableFactory.create((CatalogType)MethodPanel.this.method);
                }

                @Override
                public ProjectObject getProjectObject() {
                    return MethodPanel.this.method;
                }
            });
            this.resultTypeChooser.setInitialType(CatalogObjectImpl.get((TypeRef)this.method.getMemberType().getResultType()), false);
        }

        public void store() {
            this.descriptionEditorPanel.store();
            this.method.getMemberType().setResultType(this.resultTypeChooser.getEnsuredSelectedItem().getDynamicRef());
        }

        private void init() {
            String cols = "5dlu, pref, 5dlu";
            String rows = "2dlu, pref,2dlu, pref, 2dlu, pref, 2dlu, pref,2dlu";
            FormLayout layout = new FormLayout(cols, rows);
            PanelBuilder builder = new PanelBuilder(layout, (UiContainer)this);
            this.descriptionEditorPanel = new DescriptionEditorPanel((UiContainer)this);
            UiComponent argumentsPanel = this.buildArgumentsPanel(this);
            UiComponent returnTypePanel = this.buildReturnTypePanel(this);
            CellConstraints cc = layout.createCellConstraints();
            builder.add((UiComponent)this.descriptionEditorPanel, cc.xy(2, 2));
            builder.add(returnTypePanel, cc.xy(2, 4));
            builder.add(argumentsPanel, cc.xy(2, 6));
        }

        private UiComponent buildArgumentsPanel(MethodPanel methodPanel) {
            return new Panel((UiContainer)methodPanel);
        }

        private UiComponent buildReturnTypePanel(MethodPanel methodPanel) {
            Panel result = new Panel((UiContainer)methodPanel);
            String cols = "2dlu, max(80px;pref), 5dlu, pref:grow,2dlu:grow";
            String rows = "0dlu, pref,0dlu";
            FormLayout layout = new FormLayout(cols, rows);
            result.setLayout((Layout)layout);
            CellConstraints cc = layout.createCellConstraints();
            ComponentCatalog typeRepository = this.method.getProject().getComponentCatalog();
            this.resultTypeChooser = TypeChooserPanel.create((UiContainer)result, (ComponentCatalog)typeRepository);
            this.resultTypeChooser.setEnabled(false);
            result.add((UiComponent)Label.create((UiContainer)result, (Msg)DesignerMsg.RETURNS), (Object)cc.xy(2, 2));
            result.add((UiComponent)this.resultTypeChooser, (Object)cc.xy(4, 2));
            return result;
        }
    }

    static class MoveUpAction
    extends BaseAction {
        MoveUpAction() {
            super(UIMsg.MOVE_UP);
            this.requires(CatalogMember.class);
        }

        public void run() {
            ((CatalogMember)this.getSelection().as(CatalogMember.class)).moveUp();
        }

        protected void updateEnableStatus(Selection selection) {
            CatalogMember member = (CatalogMember)selection.as(CatalogMember.class);
            this.setEnabled(member.getPosition() > 1 && member.isMutable());
        }
    }

    static class MoveDownAction
    extends BaseAction {
        MoveDownAction() {
            super(UIMsg.MOVE_DOWN);
            this.requires(CatalogMember.class);
        }

        public void run() {
            ((CatalogMember)this.getSelection().as(CatalogMember.class)).moveDown();
        }

        protected void updateEnableStatus(Selection selection) {
            CatalogMember member = (CatalogMember)selection.as(CatalogMember.class);
            int length = member.getParentObject().getAttributes().toArray().length;
            this.setEnabled(member.getPosition() != length && member.isMutable());
        }
    }
}

