/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.editor;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.ComponentStructureAbstractPanel;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.catalog.bpmobjects.attributes.AttributePropertiesEditor;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FOAttributePropertiesPanelEnabler;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.StorageAndConstraintsPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.TypePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.DefaultValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.fusion.studio.editor.DescriptionEditorPanel;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.documentables.DocumentableFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.AbstractTypeRef;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.util.documentation.Documentable;

public class AttributePanel
extends ComponentStructureAbstractPanel
implements AttributePropertiesEditor {
    protected CatalogObject object;
    protected ObjectPropertyListener propertyObserver;
    private CatalogMember attribute;
    private ObjectPropertyListener attributeNameListener;
    private StorageAndConstraintsPanel constraintsPanel;
    private DefaultValuePanel defaultValuePanel;
    private DescriptionEditorPanel docEditor;
    private boolean isLoading;
    private boolean loading;
    private PrecisionMediator precisionMediator;
    private TypePanel typePanel;
    private static final List<String> IGNOREABLE_CHANGES = Arrays.asList("hasGetter", "hasSetter");

    public AttributePanel(UiContainer parent, CatalogMember attribute) {
        super(parent, attribute.getParentObject());
        this.attribute = attribute;
        this.setReadOnly(!attribute.isMutable());
        this.init();
        this.object = attribute.getParentObject();
        this.propertyObserver = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                if (!AttributePanel.this.isUpdating() && !IGNOREABLE_CHANGES.contains(propertyName)) {
                    AttributePanel.this.internalObjectToEditor();
                }
            }
        };
        attribute.getMemberType().addPropertyObserver(AbstractTypeRef.ANY_PROPERTY, this.propertyObserver);
    }

    public static String getName(MethodTypeDescription mtd) {
        String path = "";
        for (TypeDescription mtdParent = mtd.getParent(); mtdParent != null && mtdParent.isInnerType(); mtdParent = mtdParent.getParent()) {
            path = mtdParent.getName() + "." + path;
        }
        path = path + mtd.getName();
        return path;
    }

    public void disposeEditor() {
        super.disposeEditor();
        this.getAttribute().removePropertyObserver(AbstractTypeRef.ANY_PROPERTY, this.propertyObserver);
        this.getAttribute().removePropertyObserver("name", this.attributeNameListener);
    }

    public void updateAttribute() {
        this.disableEvents();
        this.loadType();
        this.enableEvents();
    }

    public TypeDescription getCurrentType() {
        TypeDescription result = TypeFactory.getVoid();
        if (this.getAttribute() != null) {
            return this.getAttribute().getResultType();
        }
        return result;
    }

    public UiComponent getDefaultComponent() {
        return this.getFirstComponent();
    }

    public UiComponent getFirstComponent() {
        return this.typePanel.getFirstComponent();
    }

    public Object getObject() {
        return this.getAttribute();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.typePanel != null) {
            this.docEditor.setEnabled(!this.isReadOnly());
            this.typePanel.setEnabled(!this.isReadOnly());
            this.constraintsPanel.setEnabled(!this.isReadOnly());
            this.defaultValuePanel.setEnabled(!this.isReadOnly());
        }
    }

    public int getRestrictions() {
        int restrictions = -1;
        if (this.typePanel.isPrecisionSet()) {
            restrictions = this.typePanel.getPrecision();
        }
        return restrictions;
    }

    public boolean accept(UiComponent component) {
        return true;
    }

    public boolean accept() {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        super.addChangeListener(changeListener);
        this.typePanel.addChangeListener((ComponentStructureAbstractPanel)this);
        this.defaultValuePanel.addChangeListener((AttributePropertiesEditor)this);
    }

    public void addListener(UiComponent component) {
    }

    public void reloadPrecision(MethodTypeDescription attribute) {
        this.fireMemberChanged();
    }

    public void reloadType(MethodTypeDescription attribute, boolean typeChanged) {
        StringList validValues;
        this.loading = true;
        this.constraintsPanel.setAttribute(attribute);
        boolean nullUnselected = this.constraintsPanel.isNotNullSelected();
        this.defaultValuePanel.showDefaultValuePanelForType(attribute, nullUnselected);
        if (typeChanged && (validValues = attribute.asAttribute().getValidValues()) != null) {
            validValues.clear();
        }
        this.enablePanels();
        if (this.constraintsPanel.isNotNullSelected()) {
            this.defaultValuePanel.selectDefaultValue(true);
        }
        this.loadDescription();
        this.loading = false;
    }

    public EditorType getEditorType() {
        return EditorType.ATTRIBUTE;
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public void store() {
    }

    public Image getIcon() {
        return IconFactory.getIconFor((MethodTypeDescription)this.getAttribute());
    }

    public Object getInput() {
        return null;
    }

    public String getTitle() {
        return this.getAttribute() == null ? "" : AttributePanel.getName(this.getAttribute());
    }

    public boolean isEditing(AttributeTypeDescription attribute) {
        return this.getAttribute() == attribute;
    }

    public void refreshStructure() {
    }

    public MethodTypeDescription getAttribute() {
        return this.attribute.getMemberType();
    }

    public void notNullChanged(boolean notNullChecked) {
        this.getAttribute().asAttribute().setRequired(notNullChecked);
        this.enablePanels();
        if (notNullChecked) {
            this.defaultValuePanel.selectDefaultValue(notNullChecked);
        }
        this.defaultValuePanel.allowNullValue(!notNullChecked);
    }

    public void autoSave() {
    }

    protected UiContainer createMainPanel() {
        return this;
    }

    protected void replaceObject() {
    }

    protected void editorToObject() {
        if (this.getAttribute().getParent() == null) {
            return;
        }
        if (!this.loading) {
            this.setDirty(false);
            if (this.isLoading || this.getAttribute() == null) {
                return;
            }
            AttributeTypeDescription attribute = this.getAttribute().asAttribute();
            attribute.setRequired(this.constraintsPanel.isNotNullSelected());
            attribute.setResultType(this.getAttribute().getResultType().setReferenceType(true));
            attribute.setPrimaryKey(this.constraintsPanel.isPrimaryKeySelected());
            attribute.setVirtual(this.constraintsPanel.isVirtualSelected());
            if (!attribute.isVirtual()) {
                String typeString = attribute.getResultType().getName();
                String value = this.defaultValuePanel.getValue(typeString);
                attribute.setDefaultValue(value);
            }
            this.docEditor.store();
        }
    }

    protected void buildUI(UiContainer parent) {
        this.precisionMediator = PrecisionMediator.create();
        FuegoObjectAttributePropertiesPanel attributePanel = null;
        this.typePanel = new TypePanel(parent, this.attribute.getParentObject().getObjectType(), this.isReadOnly(), this.precisionMediator, attributePanel);
        this.constraintsPanel = new StorageAndConstraintsPanel(parent, this.isReadOnly(), (AttributePropertiesEditor)this);
        this.defaultValuePanel = new DefaultValuePanel(parent, this.isReadOnly());
        this.docEditor = new DescriptionEditorPanel(parent);
        this.constraintsPanel.addVirtualListener(new StorageAndConstraintsPanel.VirtualPropertyListener(){

            public void virtualChanged(boolean virtual) {
                FOAttributePropertiesPanelEnabler enabler = new FOAttributePropertiesPanelEnabler(AttributePanel.this.getAttribute());
                enabler.enable(AttributePanel.this.defaultValuePanel);
                enabler.enable(AttributePanel.this.constraintsPanel);
            }
        });
        this.getAttribute().addPropertyObserver("name", this.attributeNameListener);
        this.setUpPrecisionMeditator();
        this.addChangeListener();
        String cols = "5dlu, pref, 5dlu";
        String rows = "2dlu, pref,2dlu, pref, 2dlu, pref, 2dlu, pref,2dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = new PanelBuilder(layout, parent);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.docEditor, cc.xy(2, 2));
        builder.add((UiComponent)this.typePanel, cc.xy(2, 4));
        builder.add((UiComponent)this.constraintsPanel, cc.xy(2, 6));
        builder.add((UiComponent)this.defaultValuePanel, cc.xy(2, 8));
        this.enableEvents();
    }

    protected void objectToEditor() {
        if (!this.isDisposed() && this.getAttribute().getParent() != null) {
            this.updateAttribute();
        }
    }

    MethodTypeDescription getEditedAttribute() {
        return this.getAttribute();
    }

    private void loadDescription() {
        DescriptionEditorPanel.Descriptable desc = new DescriptionEditorPanel.Descriptable(){

            @Override
            public void setDescription(String description) {
                AttributePanel.this.getAttribute().setDescription(description);
            }

            @Override
            public String getDescription() {
                return AttributePanel.this.getAttribute().getDescription();
            }

            @Override
            public Documentable getDocumentable() {
                return DocumentableFactory.create((CatalogType)AttributePanel.this.attribute);
            }

            @Override
            public ProjectObject getProjectObject() {
                return AttributePanel.this.attribute;
            }
        };
        this.docEditor.load(desc);
        this.docEditor.setEnabled(!this.isReadOnly());
    }

    private void loadType() {
        boolean nullValue;
        this.isLoading = true;
        if (this.attribute == null) {
            System.err.println("AN ERROR HAS OCURRED");
            System.err.println("Please report this error to %(BPM_OBJECTS) team together with the trace below. Thank you.");
            Thread.dumpStack();
            this.isLoading = false;
            return;
        }
        this.loadDescription();
        MethodTypeDescription atd = this.attribute.getMemberType();
        this.typePanel.setAttribute(atd);
        this.constraintsPanel.setAttribute(atd);
        boolean nullUnselected = this.constraintsPanel.isNotNullSelected();
        this.defaultValuePanel.showDefaultValuePanelForType(atd, nullUnselected);
        this.defaultValuePanel.loadDefaultValue(atd);
        boolean bl = nullValue = atd.asAttribute().getDefaultValue() == null;
        if (nullValue) {
            this.defaultValuePanel.selectNull(true);
        } else {
            this.defaultValuePanel.selectDefaultValue(true);
        }
        this.enablePanels();
        if (this.constraintsPanel.isNotNullSelected()) {
            this.defaultValuePanel.selectDefaultValue(true);
            this.defaultValuePanel.allowNullValue(false);
        }
        this.isLoading = false;
    }

    private void fireMemberChanged() {
    }

    private void setUpPrecisionMeditator() {
        this.precisionMediator.setPanelToManage(this.typePanel);
        this.precisionMediator.setPanelToManage(this.defaultValuePanel);
    }

    private void addChangeListener() {
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AttributePanel.this.isReceiveEvents()) {
                    AttributePanel.this.setDirty(true);
                }
            }
        });
    }

    private void enablePanels() {
        FOAttributePropertiesPanelEnabler enabler = new FOAttributePropertiesPanelEnabler(this.getAttribute());
        enabler.setReadOnly(this.isReadOnly());
        enabler.enable(this.typePanel);
        enabler.enable(this.constraintsPanel);
        enabler.enable(this.defaultValuePanel);
    }
}

