/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor.syntaxhighlight;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.compiler.LanguageSpec;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyntax {
    private final Class<? extends LanguageSpec> languageSpec;
    private String[] styleIds;
    private final List<Style> styles = new ArrayList<Style>();

    protected AbstractSyntax(@NotNull Class<? extends LanguageSpec> languageSpec) {
        this.languageSpec = languageSpec;
    }

    public abstract String mapTokenToStyleName(int var1);

    @NotNull
    public abstract String getContentSample();

    @NotNull
    public abstract String getPresentationName();

    public abstract boolean isMultiLineToken(int var1);

    @NotNull
    public final String[] getStyleNames() {
        if (this.styleIds == null) {
            this.styleIds = new String[this.styles.size()];
            int i = 0;
            for (Style style : this.styles) {
                this.styleIds[i++] = style.getId();
            }
        }
        return this.styleIds;
    }

    public final void registerStyles(StyleRegistry styleRegistry) {
        new BuiltInStyles(styleRegistry);
        for (Style style : this.styles) {
            BaseStyle registeredStyle = styleRegistry.lookupStyle(style.getId());
            if (registeredStyle != null) continue;
            styleRegistry.createStyle(style.getId(), style.getName(), style.getParent());
        }
    }

    @NotNull
    public Class<? extends LanguageSpec> getLanguageSpec() {
        return this.languageSpec;
    }

    @NotNull
    public LanguageSpec createLanguageSpec() {
        try {
            return this.languageSpec.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void addStyle(@NotNull String id, @NotNull String name) {
        this.addStyle(id, name, null);
    }

    protected final void addStyle(@NotNull String id, @NotNull String name, @Nullable String parent) {
        this.styleIds = null;
        this.styles.add(new Style(id, name, parent));
    }

    private final class Style {
        private final String parentStyle;
        private final String styleId;
        private final String styleName;

        private Style(String styleId, String styleName, String parentStyle) {
            this.styleId = styleId;
            this.styleName = styleName;
            if (parentStyle == null) {
                parentStyle = "base-plain-style";
            }
            this.parentStyle = parentStyle;
        }

        public String getId() {
            return this.styleId;
        }

        public String getName() {
            return this.styleName;
        }

        public String getParent() {
            return this.parentStyle;
        }
    }
}

