/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor.codecompletion;

import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.CompletionSuggestion;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.editor.CompletionSupport;
import oracle.bpm.editor.EditorDocument;
import oracle.bpm.fusion.studio.codeeditor.FusionDocument;
import oracle.bpm.fusion.studio.codeeditor.codecompletion.CompletionInsightPlugin;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeRef;
import oracle.javatools.editor.insight.ListInsightData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionListInsightData
implements ListInsightData {
    private final CompletionInsightPlugin insightPlugin;
    private CompletionSuggestion[] suggestions;
    @Nullable
    private TypeRenderer typeRenderer;

    public CompletionListInsightData(CompletionInsightPlugin insightPlugin) {
        this.insightPlugin = insightPlugin;
    }

    public Object[] getData() {
        FusionDocument document = (FusionDocument)this.insightPlugin.getDocument();
        int caretPosition = this.insightPlugin.getCaretPosition();
        CompletionResult result = CompletionSupport.completeCodeAt((EditorDocument)document, (int)caretPosition);
        this.suggestions = result.getSuggestions();
        return this.suggestions;
    }

    public Object[] getMatchingData() {
        return null;
    }

    public int getMatchingDataCount() {
        return this.suggestions.length;
    }

    public Object getDefault() {
        return this.suggestions[0];
    }

    public boolean complete(Object o) {
        return this.suggest(((ListData)o).suggestion);
    }

    public void partialComplete() {
    }

    public ListModel getListModel() {
        return new AbstractListModel(){
            private static final long serialVersionUID = -6252815904926070058L;

            @Override
            public int getSize() {
                return CompletionListInsightData.this.suggestions.length;
            }

            @Override
            public Object getElementAt(int index) {
                return new ListData(CompletionListInsightData.this.suggestions[index]);
            }
        };
    }

    @NotNull
    private TypeRenderer getTypeRenderer() {
        TypeRenderer result = this.typeRenderer;
        if (result == null) {
            LanguageSpec spec;
            try {
                spec = LanguageSpec.getLanguageSpec((String)"Fuego");
            }
            catch (InvalidLanguageException e) {
                throw new IllegalArgumentException(e);
            }
            this.typeRenderer = result = spec.getTypeRenderer();
        }
        return result;
    }

    private boolean suggest(CompletionSuggestion selectedSuggestion) {
        FusionDocument document = (FusionDocument)this.insightPlugin.getDocument();
        int start = this.insightPlugin.getEditorPane().getSelectionStart();
        int end = this.insightPlugin.getEditorPane().getSelectionEnd();
        CompletionSupport.paste((EditorDocument)document, (CompletionSuggestion)selectedSuggestion, (int)start, (int)end);
        return false;
    }

    private class ListData {
        final CompletionSuggestion suggestion;

        private ListData(CompletionSuggestion suggestion) {
            this.suggestion = suggestion;
        }

        public String toString() {
            String typeText;
            String name = this.suggestion.getId();
            TypeDescription suggestionType = this.suggestion.getType();
            if (suggestionType != null) {
                TypeRenderer renderer = CompletionListInsightData.this.getTypeRenderer();
                if (suggestionType.isMember() || suggestionType.isTransformation()) {
                    MethodTypeDescription member = suggestionType.asMethod();
                    StringBuilder text = new StringBuilder(32);
                    text.append(member.getName());
                    if (!member.isAttribute()) {
                        renderer.renderArguments(member, null, text);
                    }
                    typeText = renderer.render((TypeRef)member.getResultType());
                    name = text.toString();
                } else {
                    typeText = renderer.render((TypeRef)suggestionType);
                }
            } else {
                typeText = "";
            }
            int threshold = Math.max(40, 100 - typeText.length() - 1);
            if (name.length() > threshold) {
                int breakIndex = (name = name.substring(0, threshold)).lastIndexOf(44);
                if (breakIndex == -1 || breakIndex < threshold - 10) {
                    breakIndex = name.lastIndexOf(32);
                }
                if (breakIndex != -1 && breakIndex >= threshold - 10) {
                    name = name.substring(0, breakIndex + 1);
                }
                name = name + "...";
            }
            return typeText.isEmpty() ? name : name + " : " + typeText;
        }
    }
}

